<section class="marquee_slider_inner">
    <div class="marquee marquee_slider_one">
        <?php
		if ( ! empty ( $brand_name ) ) {
			foreach ( $brand_name as $item ) {
				?>
        <div class="slide">
            <a href="" class="marquee_item">
                <?php if(!empty($item['company_logo'])): ?>
                <?php echo wp_get_attachment_image( $item['company_logo']['id'], 'full', '', [ 'class' => 'clients_logo' ] ); ?>
                <?php endif; ?>
                <div class="marquee_content">
                    <?php if (!empty($item['title'])): ?>
                    <h3><?php echo esc_html( $item[ 'title' ] ); ?><i class="eicon-arrow-right"></i></h3>
                    <?php endif; ?>
                    <?php if(!empty ($item['description'])): ?>
                    <p><?php echo esc_html( $item[ 'description' ] ); ?></p>
                    <?php endif; ?>
                </div>
            </a>
        </div>
        <?php
			}
		}
		?>
    </div>
    <div class="marquee marquee_slider_two">
        <?php
		if ( ! empty ( $brand_name_two ) ) {
			foreach ( $brand_name_two as $item ) {
				?>
        <div class="slide">
            <a href="" class="marquee_item">
                <?php if(!empty($item['company_logo_two'])): ?>
                <?php echo wp_get_attachment_image( $item['company_logo_two']['id'], 'full', '', [ 'class' => 'clients_logo' ] ); ?>
                <?php endif; ?>
                <div class="marquee_content">
                    <?php if (!empty($item['title_two'])): ?>
                    <h3><?php echo esc_html( $item[ 'title_two' ] ); ?><i class="eicon-arrow-right"></i></h3>
                    <?php endif; ?>
                    <?php if(!empty ($item['description_two'])): ?>
                    <p><?php echo esc_html( $item[ 'description_two' ] ); ?></p>
                    <?php endif; ?>
                </div>
            </a>
        </div>
        <?php
			}
		}
		?>
    </div>
    <div class="marquee marquee_slider_one">
        <?php
		if ( ! empty ( $brand_name_three ) ) {
			foreach ( $brand_name_three as $item ) {
				?>
        <div class="slide">
            <a href="" class="marquee_item">
                <?php if(!empty($item['company_logo_three'])): ?>
                <?php echo wp_get_attachment_image( $item['company_logo_three']['id'], 'full', '', [ 'class' => 'clients_logo' ] ); ?>
                <?php endif; ?>
                <div class="marquee_content">
                    <?php if (!empty($item['title_three'])): ?>
                    <h3><?php echo esc_html( $item[ 'title_three' ] ); ?><i class="eicon-arrow-right"></i></h3>
                    <?php endif; ?>
                    <?php if(!empty ($item['description_three'])): ?>
                    <p><?php echo esc_html( $item[ 'description_three' ] ); ?></p>
                    <?php endif; ?>
                </div>
            </a>
        </div>
        <?php
			}
		}
		?>
    </div>
</section>

<script>
(function($) {
    "use strict";
    $(document).ready(function() {
        if ($(".marquee_slider_inner").length) {
            function createLoop($marquee, $slider, increment) {
                var LoopDelay = 500 / 30; // How fast ticks happen...
                var Loop;

                function destroyLoop() {
                    clearInterval(Loop);
                }

                function startLoop() {
                    Loop = setInterval(function() {
                        var firstSlide = $slider.find(".slide:first-child");
                        var firstMargin = parseInt(firstSlide.css("margin-" + increment)) - 1;
                        firstSlide.css("margin-" + increment, firstMargin);

                        if (Math.abs(firstMargin) >= firstSlide.outerWidth()) {
                            firstSlide.css("margin-" + increment, 0);
                            firstSlide.appendTo($slider);
                        }
                    }, LoopDelay);
                }

                $marquee.on("mouseenter", destroyLoop);
                $marquee.on("mouseleave", startLoop);
                startLoop();
            }

            var $marquee1 = $(".marquee_slider_inner");
            var $slider1 = $marquee1.find(".marquee_slider_one");
            createLoop($marquee1, $slider1, "right");

            var $marquee2 = $(".marquee_slider_inner");
            var $slider2 = $marquee2.find(".marquee_slider_two");
            createLoop($marquee2, $slider2, "left");
        }
    });
})(jQuery)
</script>

<style>
.marquee {
    width: 100%;
    display: inline-block;
    white-space: nowrap;
    overflow: hidden;
}

.marquee .slide {
    width: auto;
    display: inline-block;
    padding: 1rem;
}

.marquee .slide h2 {
    font-family: "Playfair Display", serif;
    font-style: normal;
    font-weight: 700;
    font-size: 48px;
    line-height: 48px;
    text-transform: capitalize;
    color: #ffffff;
    margin-top: 0;
    margin-bottom: 0;
    padding-bottom: 0;
    padding-top: 0;
}

.marquee .slide h2 img {
    vertical-align: bottom;
    margin-right: 40px;
}
</style>