<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<div class="spe_flip_box_inner <?php echo esc_attr( $settings['style'] ) ?>">
    <div class="flip_overlay"></div>
    <div class="front_face">
        <div class="font_face_content">
            <?php
			if ( 'content' == $settings['front_content_type'] ) {
				\Elementor\Icons_Manager::render_icon( $settings['title-icon'], [ 'class' => 'title-icon' ] );
				if ( ! empty( $settings['front_box_title'] ) ): ?>
            <h3 class="title"> <?php echo wp_kses_post( $settings['front_box_title'] ) ?> </h3>
            <?php endif; ?>
            <?php if(!empty($settings['front_desc'])):?>
            <p><?php echo $settings['front_desc'] ?? ''; ?></p>
            <?php endif; ?>
            <?php if ( ! empty( $settings['front_box_image']['id'] ) ): ?>
            <div class="image">
                <?php echo wp_get_attachment_image( $settings['front_box_image']['id'], 'full' ) ?>
            </div>
            <?php
				endif;
			} elseif ( 'template' == $settings['front_content_type'] ) {
				if ( ! empty( $settings['front_template'] ) ) {
					echo \Elementor\Plugin::$instance->frontend->get_builder_content( $settings['front_template'], true );
				}
			}
			?>
        </div>
        <button class="flip_button">
            <?php \Elementor\Icons_Manager::render_icon( $settings['plus-icon'], [ 'class' => 'icon' ] ); ?>
        </button>
    </div>

    <div class="back_face">
        <?php
		if ( 'content' == $settings['back_content_type'] ) {
			?>
        <div class="back_face_content">
            <?php if ( ! empty( $settings['back_box_title'] ) ): ?>
            <h3> <?php echo wp_kses_post( $settings['back_box_title'] ) ?></h3>
            <?php endif; ?>
            <?php if ( ! empty( $settings['back_box_content'] ) ): ?>
            <p><?php echo wp_kses_post( $settings['back_box_content'] ) ?></p>
            <?php endif; ?>
        </div>
        <?php if ( ! empty( $settings['back_box_image']['id'] ) ): ?>
        <div class="image-column text-end">
            <?php echo wp_get_attachment_image( $settings['back_box_image']['id'], 'full' ) ?>
        </div>
        <?php
			endif;
		} elseif ( 'template' == $settings['back_content_type'] ) {
			if ( ! empty( $settings['back_template'] ) ) {
				echo \Elementor\Plugin::$instance->frontend->get_builder_content( $settings['back_template'], true );
			}
		}
		?>

        <button class="flip_button_close">
            <?php \Elementor\Icons_Manager::render_icon( $settings['minus-icon'], [ 'class' => 'icon_close' ] ); ?>
        </button>
    </div>
</div>