<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<div class="spe_features_box_item">
    <?php
    $content_type = $settings['content_type'] ?? 'content';
    if ( $content_type == 'content') {
        ?>
            <div class="spe_feature_content">
                <?php if ( ! empty( $settings['feature_title'] ) ) : ?>
                    <h4 class="spe_fe_title"><?php echo spel_kses_post( $settings['feature_title'] ) ?></h4>
                <?php endif; ?>
                <?php if ( ! empty( $settings['normal_content'] ) ): ?>
                    <p><?php echo spel_kses_post( $settings['normal_content'] ) ?></p>
                <?php endif; ?>
            </div>

        <?php if ( ! empty( $settings['feature_box_image']['id'] ) ) : ?>
            <div class="feature_img" data-parallax='{"x": -50, "y": -50, "distance": 300, "smoothness": 10}'>
                <?php echo wp_get_attachment_image( $settings['feature_box_image']['id'], 'full', '', [ 'class' => 'feature-image' ] ); ?>
            </div>
        <?php endif; ?>
        <?php
    } elseif ( $content_type == 'el_template' ) {
	    if ( ! empty( $settings['el_content'] ) ) {
		    echo \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $settings['el_content'] );
	    }
    }
    
	if ( ! empty( $settings['feature_icon']['value'] ) ) {
		?>
        <a <?php spel_button_link( $settings['box_url'] ); ?> class="features_box_layer">
            <div class="icon">
				<?php \Elementor\Icons_Manager::render_icon( $settings['feature_icon'] ); ?>
            </div>
        </a>
		<?php
	}
	?>

</div>