<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>
<div class="spider-elements-business-hours">
    <?php
	if ( $business_days_times ) {
		?>
    <div class="spider-elements-business-hours-inner">
        <?php
			foreach ( $business_days_times as $index => $item ) {

                // Day Settings
				$day_settings = $this->get_repeater_setting_key( 'enter_day', 'business_days_times', $index );
				$this->add_inline_editing_attributes( $day_settings );

                // Time Settings
                $time_settings = $this->get_repeater_setting_key( 'enter_time', 'business_days_times', $index );
                $this->add_inline_editing_attributes( $time_settings );

                // Attributes
                $this->add_render_attribute( 'wrapper', 'class', 'elementor-repeater-item-' . $item[ '_id' ] );
				?>
        <div <?php echo $this->get_render_attribute_string('wrapper') ?>>
            <div class="spe-inner spe-grid">

                <span class="heading-date spe-business-day">
                    <span <?php echo $this->get_render_attribute_string($day_settings); ?>>
                        <?php echo esc_html($item[ 'enter_day' ]); ?>
                    </span>
                </span>

                <span class="heading-time spe-business-time">
                    <span class="inner-heading-time">
                        <span <?php echo $this->get_render_attribute_string($time_settings) ?>>
                            <?php echo esc_html($item[ 'enter_time' ]); ?>
                        </span>
                    </span>
                </span>

            </div>
        </div>
        <?php
			}
			?>
    </div>
    <?php
	}
	?>
</div>