<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>
<section class="spe-business-hours">
	<?php
	if ( $dynamic_days_times ) {
		$available_status = '';
		?>
        <div class="spe-business-hours-inner">
			<?php

			foreach ( $dynamic_days_times as $index => $item ) {

				$day_settings = $this->get_repeater_setting_key( 'dynamic_enter_day', 'dynamic_days_times', $index );
				$this->add_inline_editing_attributes( $day_settings );

				$time_settings = $this->get_repeater_setting_key( 'dynamic_enter_time', 'dynamic_days_times', $index );
				$this->add_inline_editing_attributes( $time_settings );


				// Attributes
				$this->add_render_attribute( 'wrapper', 'class', 'elementor-repeater-item-' . $item[ '_id' ] );
				?>
                <div <?php echo $this->get_render_attribute_string('wrapper') ?>>
                    <div class="spe-inner">

                        <span <?php echo $this->get_render_attribute_string($day_settings); ?>>
                            <span><?php echo esc_html(ucwords($item[ 'dynamic_enter_day' ])); ?></span>
                        </span>

                        <span>
                             <?php
                             if ( $item[ 'dynamic_close_day' ] != 'yes' ) {
                                 echo esc_html($item[ 'dynamic_start_time' ]);
                             } else {
                                 echo esc_html($item[ 'dynamic_close_text' ]);
                             }
                             ?>
                        </span>

                        <span class="dynamic-separator">
                            <?php
                            if ($item[ 'dynamic_close_day' ] != 'yes') {
	                            echo esc_html( $settings[ 'dynamic_time_separator' ] );
                            }
                            ?>
                        </span>

                        <?php
                        if ( $item['dynamic_close_day' ] != 'yes' ) {
                            ?>
                            <span>
                                <?php echo esc_html($item[ 'dynamic_end_time' ]); ?>
                            </span>
                            <?php
                        }


                        //
                        $this_day = substr(ucwords($item[ 'dynamic_enter_day' ]), 0, 3);

                        if ( $settings['dynamic_timezone'] == 'yes' ) {
                            $current_date = date('D');
                        } else {
	                        $current_date = strtotime($this->set_time_zone());
                            $current_date = date('D', $current_date);
                        }


                        if ( $current_date == $this_day ) {


	                        if ($item[ 'dynamic_end_time' ] != '' && $item[ 'dynamic_close_day' ] != 'yes') {
		                        $available_status = 'Open-' .
                                   $item[ 'dynamic_enter_day' ] . '-' .
                                   $item[ 'dynamic_start_time' ] . '-' .
                                   $item[ 'dynamic_end_time' ];
	                        } else {
		                        $available_status = 'Closed-' .
                                    $item[ 'dynamic_enter_day' ];
	                        }


                        }

                        ?>

                    </div>
                </div>
				<?php
			}


			$office_status = $settings['dynamic_open_day'];
			$office_status_logic = '';
			$close_day = ''; // Initialize the variable
			$ex_stats = explode('-', $available_status);

			if (isset($ex_stats['1'])) {
				if ($ex_stats['0'] == 'Closed') {
					$close_day = ucwords(substr($ex_stats[1], 0, 3));
				}
			}

			if (!empty($close_day)) { // Check if $close_day is not empty before using it
				if ($close_day == date('D')) {
					$office_status = $settings['dynamic_close_day'];
					$office_status_logic = 'close';
				}
			}

			//by time
			if (isset($ex_stats[ '2' ]) && isset($ex_stats[ '3' ])) {
				$st_time = strtotime($ex_stats[ '2' ]);
				$end_time = strtotime($ex_stats[ '3' ]);
				if ($settings[ 'dynamic_timezone' ] == 'default') {
					$cur_time = strtotime($this->set_time_zone());;
				} else {
					$cur_time = strtotime($this->set_time_zone());
					$cur_time = strtotime(date('g:i:s A', $cur_time));
				}
				/*if ($cur_time >= $st_time && $cur_time <= $end_time) {
					$office_status = !empty($settings[ 'dynamic_open_day' ]) ? $settings[ 'dynamic_open_day' ] : '';
					$office_status_logic = 'open';
				} else {
					$office_status = !empty($settings[ 'dynamic_close_day' ]) ? $settings[ 'dynamic_close_day' ] : '';
					$office_status_logic = 'close';
				}*/
			}
			?>
        </div>

        <div class="spe-live-status">
			<?php
			if ( $office_status_logic == 'open') {
				?>
                <div class="spe-alert-success">
                    <a class="spe-alert-close"></a>
					<?php echo $office_status; ?>
                </div>
				<?php
			} else { ?>
                <div class="spe-alert-danger">
                    <a class="spe-alert-close"></a>
					<?php echo $office_status; ?>
                </div>
				<?php
			}
			?>
        </div>
		<?php
	}
	?>

</section>