<?php

namespace SPEL_PRO\Widgets;

use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Stack image Widgets
 */
class Stacked_Image extends Widget_Base
{

    public function get_name ()
    {
        return 'stacked_image'; // ID of the widget (Don't change this name)
    }

    public function get_title ()
    {
        return __('Stacked Image', 'spider-elements-pro');
    }

    public function get_icon ()
    {
        return 'eicon-image-hotspot spel-icon';
    }

    public function get_keywords ()
    {
        return [ 'spider', 'stacked_image', 'stacked image' ];
    }

    // Get Control ID
    protected function get_control_id ($control_id)
    {
        return $control_id;
    }

    public function get_categories ()
    {
        return [ 'spider-elements-pro' ];
    }

    /**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends() {
		return ['spel-main', 'ionicons', 'elegant-icon', 'spel-main-pro' ];
	}

	/**
	 * Name: get_script_depends()
	 * Desc: Register the required JS dependencies for the frontend.
	 */
	public function get_script_depends() {
		return ['spel-el-pro-widgets' ];
	}

    // define register controls
    protected function register_controls ()
    {
        // layout
        $this->stackimage_content_control();
        // $this-> stack_image_control();
        $this->stack_image_style();

        /**
         * Tab: Style
         */

    }

    public function stackimage_content_control ()
    {

        //===================== Select Preset ===========================//
        $this->start_controls_section(
            'style_sec', [
                'label' => esc_html__('Preset Skins', 'spider-elements-pro'),
            ]
            );

        $this->add_control(
            'style', [
                'label' => esc_html__('Style', 'spider-elements-pro'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    '1' => [
                        'icon' => 'style1',
                        'title' => esc_html__('01 : Default style', 'spider-elements-pro')
                    ],
                    '2' => [
                        'icon' => 'style2',
                        'title' => esc_html__('02 : Hover style', 'spider-elements-pro'),
                    ],
                    '3' => [
                        'icon' => 'style3',
                        'title' => esc_html__('03 : Hover style', 'spider-elements-pro'),
                    ],
                    '4' => [
                        'icon' => 'style4',
                        'title' => esc_html__('04 : Scrolling style', 'spider-elements-pro'),
                    ],
                ],
                'default' => '1',
            ]
        );

        $this->end_controls_section(); //End Select Style

        $this->start_controls_section(
            'stack_images',
            [
                'label' => __('Stack Image Gallery', 'spider-elements-pro'),
            ]
        );
        $this->add_control(
            'stack_image',
            [
                'label' => esc_html__( 'Add Images', 'textdomain' ),
                'type' => Controls_Manager::GALLERY,

            ]
        );

        $this->end_controls_section();
    }

    public function stack_image_style ()
    {
        $this->start_controls_section(
            'section_image_style',
            [
                'label' => __('Image Style', 'spider-elements-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'stack_image_alignment',
            [
                'label' => __('Image Alignment', 'spider-elements-pro'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'spider-elements-pro'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'top' => [
                        'title' => __('Center', 'spider-elements-pro'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'spider-elements-pro'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
            ]
        );

        $this->add_responsive_control(
            'stack_image_width',
            [
                'label' => __('Width', 'spider-elements-pro'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'px' ],
                'desktop_default' => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 50,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .stack_image' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .imgstack .stack_img' => 'width: {{SIZE}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'stack_image_height',
            [
                'label' => __('Height', 'spider-elements-pro'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .stack_image' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .imgstack .stack_img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'stack_image_padding',
            [
                'label' => __('Padding', 'spider-elements-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .stack_image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hotspot_image_border',
                'selector' => '{{WRAPPER}} .stack_image',
            ]
        );

        $this->add_responsive_control(
            'stack_image_border_radius',
            [
                'label' => __('Border Radius', 'spider-elements-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .stack_image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .imgstack .stack_img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'pro_testimonials_box_shadow',
                'label' => __('Box Shadow', 'spider-elements-pro'),
                'selectors' => [
                    '{{WRAPPER}} .stack_image',
                    '{{WRAPPER}} .imgstack .stack_img',
                ],
            ]
        );
        $this->end_controls_section();

    }


    protected function render ()
    {
        $settings = $this->get_settings_for_display();
        extract($settings); //extract all settings array to variables converted to name of key

        //Include template parts
        include "templates/stack-image/stack-image-{$settings['style']}.php";
    }
}