<?php
/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Flip Box
 *
 * @package spider\Widgets
 * @since   1.0.0
 */
class Feature_Box extends Widget_Base {

	public function get_name() {
		return 'spe_feature_box'; // ID of the widget (Don't change this name)
	}

	public function get_title() {
		return esc_html__( 'Feature Box', 'spider-elements-pro' );
	}

	public function get_icon() {
		return 'eicon-tabs spel-icon';
	}

	public function get_keywords() {
		return [ 'spider', 'feature', 'box', 'link' ];
	}

	public function get_categories() {
		return [ 'spider-elements-pro' ];
	}

	/**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends() {
		return ['spel-main', 'ionicons', 'elegant-icon', 'spel-main-pro' ];
	}

	/**
	 * Name: get_script_depends()
	 * Desc: Register the required JS dependencies for the frontend.
	 */
	public function get_script_depends() {
		return ['scroll-parallax', 'spel-el-pro-widgets' ];
	}


    /**
	 * Name: register_controls()
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function register_controls() {
		$this->elementor_content_control();
		$this->elementor_style_control();
	}

	/**
	 * Name: elementor_content_control()
	 * Desc: Register the Content Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	public function elementor_content_control() {

		// ============================ Font face Content ===========================//
		$this->start_controls_section(
			'feature_top_content', [
				'label' => __( 'Feature Content', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'content_type', [
				'label'   => esc_html__( 'Content Type', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'content'     => esc_html__( 'Contents', 'spider-elements-pro' ),
					'el_template' => esc_html__( 'Saved Template', 'spider-elements-pro' ),
				],
				'default' => 'content',
			]
		);

		$this->add_control(
			'feature_title', [
				'label'       => __( 'Title', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Feature Box Title',
				'condition'   => [
					'content_type' => 'content'
				]
			]
		);

		$this->add_control(
			'normal_content', [
				'label'       => __( 'Content', 'spider-elements-pro' ),
				'type'        => Controls_Manager::WYSIWYG,
				'label_block' => true,
				'default'     => __( 'Feature Content', 'spider-elements-pro' ),
				'condition'   => [
					'content_type' => 'content'
				]
			]
		);

		$this->add_control(
			'feature_box_image', [
				'label'     => __( 'Image', 'spider-elements-pro' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'content_type' => 'content'
				]
			]
		);

		$this->add_control(
			'el_content', [
				'label'       => __( 'Select Template', 'spider-elements-pro' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => spel_get_el_templates(),
				'label_block' => true,
				'default'     => __( 'Accordion Content', 'spider-elements-pro' ),
				'condition'   => [
					'content_type' => 'el_template'
				]
			]
		);

		$this->add_control(
			'feature_icon', [
				'label'   => esc_html__( 'Icon', 'textdomain' ),
				'type'    => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value'   => 'fa-arrow-right',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
			'box_url', [
				'label'   => __( 'Box URL', 'spider-elements-pro' ),
				'type'    => Controls_Manager::URL,
				'default' => [
					'url' => '#',
				],
			]
		);

		$this->end_controls_section(); //
	}

	/**
	 * Name: elementor_style_control()
	 * Desc: Register the Style Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */

	public function elementor_style_control() {
		//============================ Features Box section Style ============================//
		$this->start_controls_section(
			'feature_box_style', [
				'label' => __( 'Features Box', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name'     => 'box_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .spe_features_box_item',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(), [
				'name'     => 'feature_box_shadow',
				'selector' => '{{WRAPPER}} .spe_features_box_item',
			]
		);

		$this->add_responsive_control(
			'feature_box_height',
			[
				'label'      => esc_html__( 'Box Height', 'spider-elements-pro' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'vh', 'custom' ],
				'range'      => [
					'px' => [
						'min' => 10,
						'max' => 1400,
					],
					'vh' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'box_padding', [
				'label'      => __( 'Box Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();


		//============================ Features content section Style ============================//
		$this->start_controls_section(
			'features_style', [
				'label' => __( 'Features Content', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'feature_title_options', [
				'label'     => __( 'Title', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'feature_title_typo',
				'selector' => '{{WRAPPER}} .spe_features_box_item .spe_fe_title',
			]
		);
		$this->add_control(
			'feature_title_color',
			[
				'label'     => __( 'Title Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_features_box_item .spe_fe_title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'feature_title_margin', [
				'label'      => __( 'Title Margin', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'separator'  => 'after',
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item .spe_fe_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'feature_des_options', [
				'label'     => __( 'Description', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'      => 'feature_description_typo',
				'selector'  => '{{WRAPPER}} .spe_features_box_item p',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'feature_description_color',
			[
				'label'     => __( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_features_box_item p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'feature_description_margin', [
				'label'      => __( 'Margin', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'feature_box_icon', [
				'label' => __( 'Icon Style', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		//=================// Tab Icon Normal/hover State====================
		$this->start_controls_tabs(
			'style_tab_title_tabs'
		);

		//======== Normal Tab Icon========
		$this->start_controls_tab(
			'style_tab_title_normal', [
				'label' => __( 'Normal', 'spider-elements-pro' ),
			]
		);

		$this->add_responsive_control(
			'icon_size', [
				'label'      => esc_html__( 'Icon Size', 'spider-elements-pro' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => 'px',
				],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item .features_box_layer .icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'normal_feature_icon_color', [
				'label'     => __( 'Icon Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .spe_features_box_item .features_box_layer .icon' => 'color: {{VALUE}}',
				)
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name'     => 'icon_normal_background',
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .spe_features_box_item .features_box_layer .icon',
			]
		);

		$this->add_responsive_control(
			'tab_pad', [
				'label'      => __( 'Icon Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item .features_box_layer .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab(); //End Normal Tab icon

		//=== Hover Tab icon
		$this->start_controls_tab(
			'style_tab_icon_hover', [
				'label' => __( 'Hover', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'hover_feature_icon_color', [
				'label'     => __( 'Icon Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .spe_features_box_item .features_box_layer:hover .icon' => 'color: {{VALUE}};',
				)
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'icon_hover_background',
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .spe_features_box_item .features_box_layer:hover .icon',
			]
		);

		$this->end_controls_tab(); //End Hover Tab icon
		$this->end_controls_tabs(); // End Control Tabs


		$this->end_controls_section(); //

	}


	/**
	 * Name: elementor_render()
	 * Desc: Render the widget output on the frontend.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings ); //extract all settings array to variables converted to name of key

		//================= Template Parts =================//
		include "templates/feature-box/feature-box-1.php";
	}
}