<?php
/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Quote
 * @package spider\Widgets
 */
class Box_hover extends Widget_Base {

	public function get_name() {
		return 'docy_box_hover'; // ID of the widget (Don't change this name)
	}

	public function get_title() {
		return esc_html__( 'Box Hover', 'spider-elements-pro' );
	}

	public function get_icon() {
		return 'eicon-image-box spel-icon';
	}

	public function get_keywords() {
		return [ 'box', 'hover' ];
	}

	public function get_categories() {
		return [ 'spider-elements-pro' ];
	}

	/**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends() {
		return [ 'spel-main', 'ionicons', 'elegant-icon', 'spel-main-pro' ];
	}

	/**
	 * Name: get_script_depends()
	 * Desc: Register the required JS dependencies for the frontend.
	 */
	public function get_script_depends() {
		return [ 'spel-el-pro-widgets' ];
	}


	protected function register_controls() {
		$this->elementor_content_control();
		$this->elementor_style_control();
	}

	protected function elementor_content_control() {

		/**
		 * Quote Texts
		 */
		$this->start_controls_section(
			'section_text',
			[
				'label' => esc_html__( 'Box Hover Text', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'box_title',
			[
				'label'       => esc_html__( 'Title', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default'     => 'Docy cares deeply.'
			]
		);

		$this->add_control(
			'box_description',
			[
				'label'       => esc_html__( 'Description Text', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default'     => 'Nostra adipiscing sequi nisi hic venenatis pede.'
			]
		);

		$this->add_control(
			'box_image',
			[
				'label'     => esc_html__( 'Image', 'spider-elements-pro' ),
				'type'      => Controls_Manager::MEDIA,
				'separator' => 'before'
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Name: elementor_style_control()
	 * Desc: Register the Style Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	public function elementor_style_control() {
		/**
		 * Box Style Title
		 */
		$this->start_controls_section(
			'box_style',
			[
				'label' => esc_html__( 'Box', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'background',
				'types'    => [ 'classic', 'gradient' ],
				'exclude' => ['image'],
				'selector' => '{{WRAPPER}} .sp_box_hover',

			]
		);

		$this->add_responsive_control(
			'box_padding', [
				'label'      => esc_html__( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors'  => [
					'{{WRAPPER}} .sp_box_hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'box_border',
				'selector' => '{{WRAPPER}} .sp_box_hover',
			]
		);

		$this->add_responsive_control(
			'box_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .sp_box_hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		/**
		 * Style Title
		 */
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Box Contents', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'box_title-heading',
			[
				'label' => esc_html__( 'Title', 'spider-elements-pro' ),
				'type'  => Controls_Manager::HEADING
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_title',
				'selector' => '{{WRAPPER}} .box_hover_content h3',
			]
		);

		$this->add_control(
			'color_title', [
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box_hover_content h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'top_hover_transition',
			[
				'label'       => esc_html__( 'Transition Duration', 'spider-elements-pro' ),
				'type'        => Controls_Manager::SLIDER,
				'range'       => [
					'px' => [
						'max'  => 3,
						'step' => 0.1,
					],
				],
				'render_type' => 'ui',
				'selectors'   => [
					'{{WRAPPER}} .box_hover_content .text_top' => 'transition: all {{SIZE}}s',
				],
			]
		);

		$this->add_control(
			'box_description-heading',
			[
				'label'     => esc_html__( 'Hover Description', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_quote_text',
				'selector' => '{{WRAPPER}} .box_hover_content p',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box_hover_content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'box_hover_transition',
			[
				'label'       => esc_html__( 'Transition Duration', 'spider-elements-pro' ),
				'type'        => Controls_Manager::SLIDER,
				'range'       => [
					'px' => [
						'max'  => 3,
						'step' => 0.1,
					],
				],
				'render_type' => 'ui',
				'selectors'   => [
					'{{WRAPPER}} .box_hover_content .text_two' => 'transition: all {{SIZE}}s, opacity 0.1s',
				],
			]
		);

		$this->end_controls_section();
        
	}


	/**
	 * Render alert widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$settings = $this->get_settings();
		?>
        <a href="#" class="sp_box_hover">

			<?php if ( ! empty( $settings['box_image']['id'] ) ) : ?>
                <div class="box_img wow fadeIn">
					<?php echo wp_get_attachment_image( $settings['box_image']['id'], 'full' ) ?>
                </div>
			<?php endif; ?>
            <div class="box_hover_content">
				<?php
				if ( ! empty( $settings['box_title'] ) ) { ?>
                    <div class="text_top">
                        <h3><?php echo spel_kses_post( nl2br( $settings['box_title'] ) ) ?></h3>
                    </div>
					<?php
				}
				if ( ! empty( $settings['box_description'] ) ) { ?>
                    <div class="text_two">
                        <p class="description wow fadeInUp" data-wow-delay="0.5s">
							<?php echo spel_kses_post( $settings['box_description'] ) ?>
                        </p>
                    </div>
					<?php
				}
				?>
            </div>
        </a>
		<?php
	}
}