<?php
/**
 * Plugin Name: Spider Elements Pro
 * Plugin URI: https://spider-themes.net/
 * Description: Spider Elements Pro sample asset for elementor widgets.
 * Version: 1.0.0
 * Requires at least: 5.0
 * Tested up to: 6.2
 * Requires PHP: 7.4
 * Author: spider-themes
 * Author URI: https://spider-themes.net/
 * Text domain: spider-elements-pro
 * Domain Path: /languages
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) or die( 'Hey, what are you doing here? You silly human!' );

/**
 * SPEL_PRO class.
 *
 * The main class that initiates and runs the addon.
 *
 * @since 1.0.0
 */

if ( ! class_exists( 'SPEL_PRO' ) ) {

	/**
	 * Class SPEL_PRO
	 */
	class SPEL_PRO {

		/**
		 * Plugin Version
		 *
		 * Holds the version of the plugin.
		 *
		 * @since 1.0.0
		 * @var string The plugin version.
		 */
		const VERSION = '1.0.0';


		/**
		 * Instance
		 *
		 * Holds a single instance of the `Listy_Core` class.
		 *
		 * @since 1.7.0
		 *
		 * @access private
		 * @static
		 *
		 * @var SPEL_PRO A single instance of the class.
		 */
		private static $_instance = null;


		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 *
		 * @return SPEL_PRO An instance of the class.
		 * @since 1.7.0
		 *
		 * @access public
		 * @static
		 *
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		/**
		 * Clone
		 *
		 * Disable class cloning.
		 *
		 * @return void
		 * @since 1.7.0
		 *
		 * @access protected
		 *
		 */
		public function __clone() {
			// Cloning instances of the class is forbidden
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'spider-elements-pro' ), '1.0.0' );
		}


		/**
		 * Wakeup
		 *
		 * Disable unserializing the class.
		 *
		 * @return void
		 * @since 1.7.0
		 *
		 * @access protected
		 *
		 */
		public function __wakeup() {
			// Unserializing instances of the class is forbidden.
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'spider-elements-pro' ), '1.7.0' );
		}


		/**
		 * Constructor
		 *
		 * Initialize the Listy Core plugins.
		 *
		 * @since 1.7.0
		 *
		 * @access public
		 */
		public function __construct() {

			// Include Files
			$this->core_includes();

			// define constants
			$this->define_constants();

			add_action( 'init', [ $this, 'i18n' ] );
			add_action( 'plugins_loaded', [ $this, 'init_plugin' ] );

			// Register Category
			add_action( 'elementor/elements/categories_registered', [ $this, 'elements_register_category' ] );

			// Register widgets
			add_action( 'elementor/widgets/register', [ $this, 'on_widgets_registered' ] );

		}


		/**
		 * Include Files
		 *
		 * Load core files required to run the plugin.
		 *
		 * @since 1.7.0
		 *
		 * @access public
		 */
		public function core_includes() {

			// Extra functions
			require_once __DIR__ . '/includes/extra.php';

			// Admin and Frontend Scripts Loaded
			if ( is_admin() ) {
				require_once __DIR__ . '/includes/Admin/Assets.php';
			} else {
				require_once __DIR__ . '/includes/Frontend/Assets.php';
			}


			/**
			 * Register Advance Features Control Tab
			 */

			//Container & Section Features
			require_once __DIR__ . '/includes/Admin/Extension/features-box.php';

			// Widgets Features
            $elements_opt   = get_option( 'spel_features_settings' );
            if ( isset($elements_opt['spel_reveal_animation']) && $elements_opt[ 'spel_reveal_animation' ] == 'on' ) {
                require_once __DIR__ . '/includes/Admin/Extension/reveal-animation.php';
            }

			require_once __DIR__ . '/includes/Admin/Extension/common.php';

		}


		/**
		 * Load Textdomain
		 *
		 * Load plugin localization files.
		 *
		 * @since 1.7.0
		 *
		 * @access public
		 */
		public function i18n() {
			load_plugin_textdomain( 'spider-elements-pro', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
		}



		public function init_plugin() {

			/*if ( is_admin() ) {
				echo '';
			} else {
				echo '';
			}*/

		}


		/**
		 * Add new Elementor Categories
		 *
		 * Register new widget categories for Listy Core widgets.
		 *
		 * @since 1.0.0
		 * @since 1.7.1 The method moved to this class.
		 *
		 * @access public
		 */
		public function elements_register_category() {

			\Elementor\Plugin::instance()->elements_manager->add_category( 'spider-elements-pro', [
				'title' => __( 'Spider Elements Pro', 'spider-elements-pro' ),
			], 1 );

		}

		/**
		 * Register New Widgets
		 *
		 * Include Listy Core widgets files and register them in Elementor.
		 *
		 * @since 1.0.0
		 * @since 1.7.1 The method moved to this class.
		 *
		 * @access public
		 */
		public function on_widgets_registered() {
			$this->include_widgets();
			$this->register_widgets();
		}


		/**
		 * Include Widgets files
		 *
		 * Load widgets files
		 *
		 * @since 1.2.0
		 * @access private
		 */
		private function include_widgets() {

			require_once( __DIR__ . '/widgets/Accordion_Article.php' );
			require_once( __DIR__ . '/widgets/Box_hover.php' );
			require_once( __DIR__ . '/widgets/Flip_Box.php' );
			require_once( __DIR__ . '/widgets/Hotspot.php' );
			require_once( __DIR__ . '/widgets/Image_hover.php' );
			require_once( __DIR__ . '/widgets/Image_Slides.php' );
			require_once( __DIR__ . '/widgets/Stacked_Image.php' );
			require_once( __DIR__ . '/widgets/Feature_Box.php' );
			require_once( __DIR__ . '/widgets/Business_Hours.php' );
			require_once( __DIR__ . '/widgets/Marquee_slider.php' );
		}

		/**
		 * Register Widgets
		 *
		 * Register new Elementor widgets.
		 *
		 * @since 1.0.0
		 * @since 1.7.1 The method moved to this class.
		 *
		 * @access private
		 */
		private function register_widgets() {

			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Accordion_Article() );
			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Box_hover() );
			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Flip_Box() );
			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Hotspot() );
			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Stacked_Image() );
			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Image_hover() );
			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Image_Slides() );
			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Feature_Box() );
			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Business_Hours() );
			\Elementor\Plugin::instance()->widgets_manager->register( new SPEL_PRO\Widgets\Marquee_Slider() );

		}


		/**
		 * @return void
		 * @since 1.7.0
		 * @access public
		 * @static
		 */
		public function define_constants() {

			//SPF(Short form - Spider Elements)
			define( 'SPEL_PRO_VERSION', self::VERSION );
			define( 'SPEL_PRO_FILE', __FILE__ );
			define( 'SPEL_PRO_PATH', __DIR__ );
			define( 'SPEL_PRO_URL', plugins_url( '', SPEL_PRO_FILE ) );
			define( 'SPEL_PRO_ASSETS', SPEL_PRO_URL . '/assets' );
			define( 'SPEL_PRO_CSS', SPEL_PRO_URL . '/assets/css' );
			define( 'SPEL_PRO_JS', SPEL_PRO_URL . '/assets/js' );
			define( 'SPEL_PRO_IMG', SPEL_PRO_URL . '/assets/images' );
			define( 'SPEL_PRO_VEND', SPEL_PRO_URL . '/assets/vendors' );

		}


	}
}

/**
 * Initialize the main plugin class
 *
 * @return \SPEL_PRO
 *
 */
if (!function_exists('spel_pro')) {

    function spel_pro ()
    {
        return SPEL_PRO::instance();
    }

    //kick-off the plugin
    spel_pro();
}