<?php
namespace SPEL_PRO\includes\Frontend;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Assets Class
 */
class Assets {

	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'register_scripts' ] );
	}

	public function register_scripts() {

		// Register Widget's Editor Style's
		add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'register_widget_styles' ] );
		add_action( 'elementor/editor/before_enqueue_styles', [ $this, 'register_widget_styles' ] );

		// Register Widget's Frontend Style's
		add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'register_widget_styles' ] );

		// Register Elementor Preview Editor Script's
		add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'register_editor_scripts' ] );
		add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'register_editor_scripts' ] );

	}


	/**
	 * Register Widget Scripts
	 *
	 * Register custom style required to run Spider Elements.
	 *
	 * @access public
	 */
	function register_widget_styles() {

		wp_enqueue_style('spel-pro-extension', SPEL_PRO_CSS . '/extension.css');

		wp_register_style( 'spel-main-pro', SPEL_PRO_CSS . '/main.css' );

	}


	/**
	 * Register Widget Styles
	 *
	 * Register custom styles required to run Spider Elements.
	 *
	 * @access public
	 */
	function register_editor_scripts() {
		wp_register_script( 'spel-el-pro-widgets', SPEL_PRO_JS . '/elementor-widgets.js', [
			'jquery',
			'elementor-frontend'
		], SPEL_PRO_VERSION, true );
	}


}

new Assets();