<?php
namespace Elementor;
namespace SPEL_PRO\includes\Admin\Extension;

use Elementor\Controls_Manager;
use Elementor\Element_Base;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class SpiderElements_Reveal_Animation {

	public function __construct() {

		// Elementor Heading, Text Editor Widget Support
		add_action( 'elementor/element/heading/section_title_style/after_section_end', [ $this, 'register_section_controls' ] );
		add_action( 'elementor/element/text-editor/section_editor/after_section_end', [ $this, 'register_section_controls' ] );

		//Scripts
		add_action( 'elementor/editor/after_register_scripts', [ $this, 'enqueue_scripts' ] );
		add_action( 'elementor/frontend/after_register_scripts', [ $this, 'enqueue_scripts' ] );

		// Add the 'before_render' action hook to the widget
		add_action( 'elementor/editor/before_render', [ $this, 'callback_render_display_content' ], 99 );
		add_action( 'elementor/frontend/before_render', [ $this, 'callback_render_display_content' ], 99 );

	}


	public function callback_render_display_content( Element_Base $element) {

		$spe_reveal_anim_enable = $element->get_settings_for_display( 'spe_reveal_anim_enable' );
		$spe_highlighted_text_enable = $element->get_settings_for_display( 'spe_highlighted_text_enable' );

		if ( 'yes' === $spe_reveal_anim_enable ) {
			$element->add_render_attribute( '_wrapper', 'class', 'spe-reveal-anim-text' );
		}

		if ( 'yes' === $spe_highlighted_text_enable ) {
			$element->add_render_attribute( '_wrapper', 'class', 'spe-reveal-text' );
		}

	}

	public function enqueue_scripts() {
		wp_enqueue_script( 'gsap', SPEL_PRO_VEND . '/animation/gsap.min.js', ['jquery'], '3.12.0', true );
		wp_enqueue_script( 'ScrollTrigger', SPEL_PRO_VEND . '/animation/scroll-trigger.min.js', ['jquery'], '3.12.0', true );
		wp_enqueue_script( 'spe-reveal-anim', SPEL_PRO_JS . '/extension/reveal-anim.js', [ 'jquery', 'gsap', 'ScrollTrigger' ], SPEL_PRO_VERSION, true );
	}

	public function register_section_controls( Element_Base $element) {


		//=============== Start Reveal Animation ===============//
		$element->start_controls_section(
			'spe_reveal_anim_sec', [
				'label' => esc_html__( 'Reveal Animation', 'spider-elements-pro' ) . SPEL_TEXT_BADGE,
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$element->add_control(
			'spe_reveal_anim_enable', [
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label'              => esc_html__( 'Enable Animation', 'spider-elements-pro' ),
				'frontend_available' => true,
				'return_value'       => 'yes',
				'default'            => 'no',
			]
		);

		$element->end_controls_section(); // End Section

	}


}

new SpiderElements_Reveal_Animation();