(function ($, elementor) {
  "use strict";
  var $window = $(elementor);

  var spiderElements = {
    onInit: function () {
      var E_FRONT = elementorFrontend;
      var widgetHandlersMap = {
        "docly_hotspot.default": spiderElements.hotspot,
        "docy_flip_box.default": spiderElements.flip_box,
        "accordion_article.default": spiderElements.accordionArticle,
      };

      $.each(widgetHandlersMap, function (widgetName, callback) {
        E_FRONT.hooks.addAction(
          "frontend/element_ready/" + widgetName,
          callback
        );
      });
    },

    /*============ accordionArticle js ==============*/
    accordionArticle: function ($scope) {
      let accordionArt = $scope.find(".se_tab_title");
      accordionArt.on("click", function (event) {
        event.preventDefault(); // This line should prevent the default behavior
        var $this = $(this);
        var $parent = $this.parent();
        $(this).toggleClass("active");
        $parent.find(".collapse").slideToggle("slow");
        return false;
      });
    },

    //======================== _flipbox =========================== //
    flip_box: function ($scope) {
      $(".flip_button").each(function (i) {
        $(this).on("click", function () {
          $(".spe_flip_box_inner").eq(i).addClass("flip");
        });
      });

      $(".flip_button_close,.flip_overlay").on("click", function () {
        $(".spe_flip_box_inner").removeClass("flip");
      });
    },
    get flipbox() {
      return this._flipbox;
    },
    set flipbox(value) {
      this._flipbox = value;
    },
    //======================== hotspot =========================== //
    hotspot: function ($scope) {
      setInterval(function () {
        var active = $(".hotspot_list li.active");
        active.removeClass("active");
        if (active.next("li").length == 0) {
          active
            .parent(".hotspot_list")
            .find("li:first-child")
            .addClass("active");
        } else {
          active.next("li").addClass("active");
        }
      }, 3000);
    },
  };

  $window.on("elementor/frontend/init", spiderElements.onInit);
})(jQuery, window);
