<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

get_header();

$meta = get_post_meta(get_the_ID(), 'jobly_meta_company_options', true);
$website = $meta[ 'company_website' ] ?? '';
$website_target = $website[ 'target' ] ?? '_self';
?>

    <section class="company-details pt-110 lg-pt-80 pb-160 xl-pb-150 lg-pb-80">
        <div class="container">
            <div class="row">

                <div class="col-xxl-3 col-xl-4 order-xl-last">
                    <div class="job-company-info ms-xl-5 ms-xxl-0 lg-mb-50">
                        <?php
                        if (has_post_thumbnail()) {
                            the_post_thumbnail('full', array( 'class' => 'lazy-img m-auto logo' ));
                        }
                        ?>
                        <div class="text-md text-dark text-center mt-15 mb-20 lg-mb-10"><?php the_title() ?></div>
                        <?php if (!empty($website[ 'url' ])) : ?>
                            <div class="text-center">
                                <a href="<?php echo esc_url($website[ 'url' ]) ?>" class="website-btn-two tran3s"
                                   target="<?php echo esc_attr($website_target) ?>">
                                    <?php echo esc_html($website[ 'text' ]) ?>
                                </a>
                            </div>
                        <?php endif; ?>

                        <div class="border-top mt-35 lg-mt-20 pt-25">
                            <ul class="job-meta-data row style-none">

                                <?php
                                // Retrieve the repeater field configurations from settings options
                                $specifications = jobly_opt('company_specifications');
                                if ($specifications) {

                                    foreach ( $specifications as $field ) {

                                        $meta_name = $field[ 'meta_name' ] ?? '';
                                        $meta_key = $field[ 'meta_key' ] ?? '';

                                        // Get the stored meta-values
                                        $meta_options = get_post_meta(get_the_ID(), 'jobly_meta_company_options', true);

                                        if (isset($meta_options[ $meta_key ])) {
                                            ?>
                                            <li class="col-12">
                                                <?php
                                                if (!empty($meta_options[ $meta_key ])) {
                                                    echo '<span>' . esc_html($meta_name) . ':</span>';
                                                }
                                                if (!empty($meta_options[ $meta_key ] && is_array($meta_options[ $meta_key ]))) {
                                                    echo '<div>';
                                                    foreach ( $meta_options[ $meta_key ] as $value ) {
                                                        $trim_value = str_replace('@space@', ' ', $value);
                                                        echo esc_html($trim_value);
                                                    }
                                                    echo '</div>';
                                                }
                                                ?>
                                            </li>
                                            <?php
                                        }
                                    }

                                }

                                $terms = wp_get_post_terms(get_the_ID(), 'company_cat', array( 'fields' => 'names' ));
                                if (is_array($terms)) {
                                    ?>
                                    <li class="col-12">
                                        <span><?php printf(_n('Category:', 'Categories:', count($terms), 'jobly')) ?></span>
                                        <?php echo '<div>' . implode(', ', $terms) . '</div>'; ?>
                                    </li>
                                    <?php
                                }

                                $social_icons = jobly_opt('jobly_social_icons');
                                if (is_array($social_icons)) {
                                    ?>
                                    <li class="col-12">
                                        <span><?php esc_html_e('Social: ', 'jobly'); ?></span>
                                        <div>
                                            <?php
                                            foreach ( $social_icons as $item ) {
                                                if (!empty($item[ 'url' ])) { ?>
                                                    <a href="<?php echo esc_url($item[ 'url' ]) ?>" class="me-3">
                                                        <i class="<?php echo esc_attr($item[ 'icon' ]) ?>"></i>
                                                    </a>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                    </li>
                                    <?php
                                }
                                ?>
                            </ul>

                            <a href="<?php echo jobly_get_selected_company_count(get_the_ID(), true); ?>"
                               class="btn-ten fw-500 text-white w-100 text-center tran3s mt-25">
                                <?php esc_html_e('Posted Jobs', 'jobly'); ?>
                            </a>
                        </div>
                    </div>
                    <!-- /.job-company-info -->
                </div>

                <div class="col-xxl-9 col-xl-8 order-xl-first">
                    <div class="details-post-data me-xxl-5 pe-xxl-4">

                        <?php the_content(); ?>

                        <nav class="share-option mt-60">
                            <?php jobly_social_share_icons() ?>
                        </nav>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="company-open-position pt-80 lg-pt-60 pb-100 lg-pb-60">
        <div class="container">

            <div class="row justify-content-between align-items-center">
                <div class="col-lg-6">
                    <div class="title-two">
                        <h2><?php esc_html_e('Open Position', 'jobly'); ?></h2>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="d-flex justify-content-lg-end">
                        <a href="<?php echo esc_url(get_post_type_archive_link('job')) ?>" class="btn-six">
                            <?php esc_html_e('Explore More', 'jobly'); ?>
                        </a>
                    </div>
                </div>
            </div>

            <div class="mt-50">
                <?php
                $args = array(
                    'post_type' => 'job',
                    'posts_per_page' => -1,
                    'meta_query' => array(
                        'relation' => 'AND', // Optional, defaults to "AND
                        array(
                            'key' => 'jobly_meta_options',
                            'value' => get_the_ID(),
                            'compare' => 'LIKE',
                        ),
                    ),
                );

                $jobs = new WP_Query($args);

                while ( $jobs->have_posts() ) : $jobs->the_post();
                    // Get the selected company ID
                    $job_meta = get_post_meta(get_the_ID(), 'jobly_meta_options', true);
                    $company_id = $job_meta[ 'select_company' ] ?? '';
                    ?>
                    <div class="job-list-one style-two position-relative mb-20">
                        <div class="row justify-content-between align-items-center">
                            <div class="col-xxl-3 col-lg-4">
                                <div class="job-title d-flex align-items-center">
                                    <a href="<?php the_permalink(); ?>" class="logo">
                                        <?php the_post_thumbnail('full', [ 'class' => 'lazy-img m-auto' ]); ?>
                                    </a>
                                    <a href="<?php the_permalink(); ?>" class="title fw-500 tran3s">
                                        <?php the_title('<h3>', '</h3>') ?>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-4 col-sm-6 ms-auto">
                                <?php if (jobly_get_meta_attributes('jobly_meta_options', 'company_open_job_meta_1')) : ?>
                                    <a href="<?php the_permalink(); ?>" class="job-duration fw-500">
                                        <?php echo jobly_get_meta_attributes('jobly_meta_options', 'company_open_job_meta_1') ?>
                                    </a>
                                <?php endif; ?>
                                <div class="job-date">
                                    <?php the_time(get_option('date_format')) . esc_html_e(' by', 'jobly') ?>
                                    <a href="<?php echo esc_url(get_permalink($company_id)) ?>">
                                        <?php echo get_the_title($company_id) ?>
                                    </a>
                                </div>
                            </div>
                            <div class="col-xxl-2 col-lg-3 col-md-4 col-sm-6 ms-auto xs-mt-10">
                                <?php if (jobly_get_meta_attributes('jobly_meta_options', 'company_open_job_meta_2')) : ?>
                                    <div class="job-location">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php echo jobly_get_meta_attributes('jobly_meta_options', 'company_open_job_meta_2') ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="job-category">
                                    <a href="<?php echo jobly_get_first_taxonomoy_link() ?>">
                                        <?php echo jobly_get_first_taxonomoy_name(); ?>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-4">
                                <div class="btn-group d-flex align-items-center justify-content-md-end sm-mt-20">
                                    <a href="<?php the_permalink(); ?>" class="apply-btn text-center tran3s">
                                        <?php esc_html_e('APPLY', 'jobly'); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                endwhile;
                wp_reset_postdata();
                ?>
            </div>
        </div>
    </section>
<?php

get_footer();
