<?php
/**
 * Plugin Name: Jobi Core
 * Requires Plugins: elementor
 * Plugin URI: https://themeforest.net/user/spider-themes/portfolio
 * Description: This plugin adds the core features to the Jobi WordPress theme. You must have to install this plugin to get all the features included with the Jobi theme.
 * Version: 1.3.0
 * Requires at least: 5.0
 * Tested up to: 6.7
 * Requires PHP: 7.4
 * Author: spider-themes
 * Author URI: https://themeforest.net/user/spider-themes/portfolio
 * Text domain: jobi-core
 */
if (!defined('ABSPATH')) {
    die('-1');
}

// Jobi Core Directories
define('JOBI_CORE_IMAGES', plugins_url('widgets/images/', __FILE__));
define('JOBI_CORE_PATH', plugin_dir_path(__FILE__));
define('JOBI_CORE_URL', plugin_dir_url(__FILE__));

// Make sure the same class is not loaded twice in free/premium versions.
if (!class_exists('Jobi_core')) {
    /**
     * Main Jobi Core Class
     *
     * The main class that initiates and runs the Jobi Core plugin.
     */
    class Jobi_core {

		/**
         * Jobi Core Version
         *
         * Holds the version of the plugin.
         *
         * @var string The plugin version.
         */
        const VERSION = '1.3.0';

        /**
         * Instance
         *
         * Holds a single instance of the `Jobi_Core` class.
         *
         * @access private
         * @static
         *
         * @var Jobi_Core A single instance of the class.
         */
        private static $_instance = null;

        /**
         * Instance
         *
         * Ensures only one instance of the class is loaded or can be loaded.
         *
         * @access public
         * @static
         *
         * @return Jobi_Core An instance of the class.
         */
        public static function instance ()
        {
            if (is_null(self::$_instance)) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Clone
         *
         * Disable class cloning.
         *
         * @access protected
         *
         * @return void
         */
        public function __clone ()
        {
            // Cloning instances of the class is forbidden
            _doing_it_wrong(__FUNCTION__, esc_html__('Cheatin&#8217; huh?', 'jobi-core'), '1.7.0');
        }

        /**
         * Wakeup
         *
         * Disable unserializing the class.
         *
         * @access protected
         *
         * @return void
         */
        public function __wakeup ()
        {
            // Unserializing instances of the class is forbidden.
            _doing_it_wrong(__FUNCTION__, esc_html__('Cheatin&#8217; huh?', 'jobi-core'), '1.7.0');
        }

        /**
         * Constructor
         *
         * Initialize the Jobi Core plugins.
         *
         * @access public
         */
        public function __construct ()
        {
            $this->init_hooks();
            $this->core_includes();
            do_action('jobi_core_loaded');
        }

        /**
         * Include Files
         *
         * Load core files required to run the plugin.
         *
         * @access public
         */
        public function core_includes ()
        {

            // Extra functions
            require_once __DIR__ . '/inc/extra.php';

        }

        /**
         * Init Hooks
         *
         * Hook into actions and filters.
         *
         * @access private
         */
        private function init_hooks ()
        {
            add_action('init', [ $this, 'i18n' ]);
            add_action('plugins_loaded', [ $this, 'init' ]);
        }

        /**
         * Load Textdomain
         *
         * Load plugin localization files.
         *
         * @access public
         */
        public function i18n ()
        {
            load_plugin_textdomain('jobi-core', false, plugin_basename(dirname(__FILE__)) . '/languages');
        }

        /**
         * Init Jobi Core
         *
         * Load the plugin after Elementor (and other plugins) are loaded.
         *
         * @access public
         */
        public function init ()
        {

            // Add new Elementor Categories
            add_action('elementor/init', [ $this, 'add_elementor_category' ]);

            // Register Widget Scripts
            add_action('elementor/editor/before_enqueue_scripts', [ $this, 'enqueue_elementor_editor_styles' ]);

            // Register Font Icons
            add_filter('elementor/icons_manager/additional_tabs', [ $this, 'bootstrap_font_icons' ]);
        }

        /**
         * Add new Elementor Categories
         *
         * Register new widget categories for Jobi Core widgets.
         *
         * @since 1.0.0
         * @since 1.7.1 The method moved to this class.
         *
         * @access public
         */
        public function add_elementor_category ()
        {
            \Elementor\Plugin::instance()->elements_manager->add_category('jobi-elements', [
                'title' => __('Jobi Elements', 'jobi-core'),
            ], 1);
        }

        public function enqueue_elementor_editor_styles () {
            wp_enqueue_style('jobi-elementor-editor', plugins_url('assets/css/elementor-editor.css', __FILE__));
        }

        /***
         * Added Custom Font Icon Integrated Elementor Icon Library
         */
        public function bootstrap_font_icons ($custom_fonts)
        {
            $css_data = plugins_url('/assets/vendors/bootstrap-icons/font.css', __FILE__);
            $json_data = plugins_url('/assets/vendors/bootstrap-icons/bootstrap_font.json', __FILE__);

            $custom_fonts[ 'bootstrap-icon' ] = [
                'name' => 'bootstrap-icon',
                'label' => esc_html__('Bootstrap Icons', 'jobi'),
                'url' => $css_data,
                'prefix' => '',
                'displayPrefix' => '',
                'labelIcon' => 'icon_star',
                'ver' => '',
                'fetchJson' => $json_data,
                'native' => true,
            ];

            return $custom_fonts;
        }
    }
}

// Make sure the same function is not loaded twice in free/premium versions.
if (!function_exists('jobi_core_load')) {
    /**
     * Load Jobi Core
     *
     * Main instance of Jobi_Core.
     *
     */
    function jobi_core_load () {
        return Jobi_core::instance();
    }

    // Run Jobi Core
    jobi_core_load();
}