<?php

/**
 * Plugin Name:       Smart bbPress nVerify - Plugin for WordPress and Envato Market
 * Plugin URI:        https://www.smartplugins.info/plugin/wordpress/smart-bbpress-nverify/
 * Description:       Integrate with bbPress forums to implement verification of the Envato purchase codes. Assign one or more Envato items to forums for purchase only access.
 * Author:            Milan Petrovic
 * Author URI:        https://www.smartplugins.info/
 * Text Domain:       smart-bbpress-nverify
 * Version:           4.2
 * Requires at least: 5.8
 * Tested up to:      6.6
 * Requires PHP:      7.4
 *
 * == Copyright ==
 * Copyright 2008 - 2024 Milan Petrovic (email: support@smartplugins.info)
 */

$sbv_dirname_basic = dirname( __FILE__ ) . '/';
$sbv_urlname_basic = plugins_url( '/', __FILE__ );

define( 'SBV_PATH', $sbv_dirname_basic );
define( 'SBV_URL', $sbv_urlname_basic );

if ( ! defined( 'SBV_EOL' ) ) {
	define( 'SBV_EOL', "\r\n" );
}

require_once( SBV_PATH . 'core/defaults.php' );

require_once( SBV_PATH . 'core/objects/loader.php' );
require_once( SBV_PATH . 'core/objects/validator.php' );
require_once( SBV_PATH . 'core/objects/bbpress.php' );

require_once( SBV_PATH . 'core/functions/d4plib.php' );
require_once( SBV_PATH . 'core/functions/internal.php' );
require_once( SBV_PATH . 'core/functions/public.php' );
require_once( SBV_PATH . 'core/functions/render.php' );

smart_sbv_core();

sbv_validator();
sbv_bbpress();

if ( is_admin() ) {
	require_once( SBV_PATH . 'core/admin.php' );
}

if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
	require_once( SBV_PATH . 'core/ajax.php' );
}
