/*jslint regexp: true, nomen: true, undef: true, sloppy: true, eqeq: true, vars: true, white: true, plusplus: true, maxerr: 50, indent: 4 */
/*global sbv_verificaton_data*/

;(function($, window, document, undefined) {
    "use strict";

    window.wp = window.wp || {};
    window.wp.smartplugins = window.wp.smartplugins || {};

    window.wp.smartplugins.verification = {
        profile: function() {
            $(".sbv-bulk-code-block input").mask("********-****-****-****-************", {placeholder: "_"});

            $(".sbv-bulk-add-more").click(function(e) {
                e.preventDefault();

                var input = $(".sbv-bulk-code-block input")
                    .first()
                    .clone()
                    .fadeIn()
                    .val("")
                    .mask("********-****-****-****-************", {placeholder: "_"});

                $(".sbv-bulk-code-block").append(input);
            });
        },
        init: function() {
            var exec = $("#sbv-verify-exec"),
                code = $("#sbv-verify-code"),
                note = $(".sbv-purchase-submit .bbp-template-notice");

            if (sbv_verificaton_data.masked) {
                exec.prop("disabled", true);
                code.mask("********-****-****-****-************", {
                    placeholder: "_",
                    completed: function() {
                        $("#sbv-verify-exec").prop("disabled", false);
                    }
                });
            }

            $(document).on("click", ".sbv-show-where-step", function(e) {
                e.preventDefault();

                $(this)
                    .fadeOut()
                    .next()
                    .slideDown();
            });

            exec.click(function(e) {
                e.preventDefault();

                code.prop("disabled", true);
                exec.prop("disabled", true);

                note.removeClass("error info")
                    .addClass("sbv-wait")
                    .show();

                var forum_id = parseInt($("#sbv-verify-frid").val()),
                    on_ok_action = $("#sbv-verify-onok").val();

                if (forum_id === 0 || isNaN(forum_id)) {
                    forum_id = sbv_verificaton_data.forum;
                }

                var request = {
                    code: $("#sbv-verify-code").val(),
                    ctrl: $("#sbv-verify-ctrl").val(),
                    forum: forum_id
                };

                $.ajax({
                    dataType: "json", data: request,
                    url: sbv_verificaton_data.ajax + "?action=sbv_verify_purchase",
                    success: function(json) {
                        note.removeClass("sbv-wait");

                        if (json.status === "error") {
                            note.addClass("error");
                        } else {
                            note.addClass("info");
                        }

                        $("p", note).html(json.message);

                        if (json.status === "error") {
                            code.prop("disabled", false);
                            exec.prop("disabled", false);
                        } else {
                            setTimeout(function() {
                                if (on_ok_action === '' || on_ok_action === 'reload') {
                                    window.location.reload(true);
                                } else if (on_ok_action === 'hide') {
                                    $("#sbv-protection-block").slideUp(function() {
                                        $(this).remove();
                                    });
                                }
                            }, 2000);
                        }
                    }
                });
            });
        }
    };

    $(document).ready(function() {
        wp.smartplugins.verification.init();
    });
})(jQuery, window, document);
