/*jslint regexp: true, nomen: true, undef: true, sloppy: true, eqeq: true, vars: true, white: true, plusplus: true, maxerr: 50, indent: 4 */
/*global sbv_admin_meta_data*/

;(function($, window, document, undefined) {
    "use strict";

    window.wp = window.wp || {};
    window.wp.smartplugins = window.wp.smartplugins || {};

    window.wp.smartplugins.meta = {
        init: function() {
            $(document).on("change", ".sbv-meta-item select.sbvitem-author-select", function() {
                var val = $(this).val(),
                    block = $(this).parent().next();

                if (val === "global") {
                    block.hide();
                } else {
                    block.show();
                }
            });

            $(document).on("click", ".sbv-meta-remove-item", function(e) {
                e.preventDefault();

                if (confirm(sbv_admin_meta_data.text_are_you_sure)) {
                    $(this).parent().fadeOut(function() {
                        $(this).remove();
                    });
                }
            });

            $(document).on("change", ".sbv-meta-select select", function(e) {
                var sel = $(this).val();

                if (sel === 'items') {
                    $(".sbv-meta-items").slideDown();
                    $(".sbv-meta-account").hide();
                } else {
                    $(".sbv-meta-items").hide();
                    $(".sbv-meta-account").slideDown();
                }
            });

            $(document).on("click", "#sbv-meta-add-new-item", function(e) {
                e.preventDefault();

                var meta = $("#sbv-meta-item-id"), id = parseInt(meta.val()),
                    name = "", item = $(".sbv-meta-default-item").clone();

                item.removeClass("sbv-meta-default-item")
                    .find("input, select").each(function() {
                    name = $(this).attr("name").replace("0", id);
                    $(this).attr("name", name);
                });
                item.fadeIn();

                id++;

                meta.val(id);
                $("#sbv-meta-items-list").append(item);
            });
        }
    };

    $(document).ready(function() {
        wp.smartplugins.meta.init();
    });
})(jQuery, window, document);
