/*jslint regexp: true, nomen: true, undef: true, sloppy: true, eqeq: true, vars: true, white: true, plusplus: true, maxerr: 50, indent: 4 */
/* global ajaxurl */

;(function($, window, document, undefined) {
    "use strict";

    window.wp = window.wp || {};
    window.wp.smartplugins = window.wp.smartplugins || {};

    window.wp.smartplugins.admin = {
        current: null,
        removal: null,
        init: function() {
            var submit = $("#verify_submit");

            $('#apikey-password, #verify_api_key').hidePassword(true);

            submit.prop("disabled", true);

            $("#verify_purchase_code").mask("********-****-****-****-************", {
                placeholder: "_",
                completed: function() {
                    submit.prop("disabled", false);
                }
            });

            submit.click(function() {
                var request = {
                    code: $("#verify_purchase_code").val(),
                    user: $("#verify_assign_id").val(),
                    nonce: $("#verify_nonce").val(),
                    username: $("#verify_user_name").val(),
                    apikey: $("#verify_api_key").val()
                };

                if (request.username !== '' && request.apikey !== '') {
                    wp.smartplugins.admin.dim.open();

                    $.ajax({
                        dataType: "html", data: request,
                        url: ajaxurl + "?action=sbv_verify_admin",
                        success: function(html) {
                            $("#svb-quick-verify-result").html(html);

                            wp.smartplugins.admin.dim.close();
                        }
                    });
                }
            });
        },
        timer: function() {
            if ($("#sct-load-timer").length > 0) {
                wp.smartplugins.admin.current = new Date();

                setInterval(function() {
                    var total_milliseconds = new Date() - wp.smartplugins.admin.current;

                    var hours = Math.floor(total_milliseconds / 3600000);
                    total_milliseconds = total_milliseconds % 3600000;

                    var minutes = Math.floor(total_milliseconds / 60000);
                    total_milliseconds = total_milliseconds % 60000;

                    var seconds = Math.floor(total_milliseconds / 1000);
                    total_milliseconds = total_milliseconds % 1000;

                    var milliseconds = Math.floor(total_milliseconds);

                    hours = wp.smartplugins.admin.pad_time_string(hours);
                    minutes = wp.smartplugins.admin.pad_time_string(minutes);
                    seconds = wp.smartplugins.admin.pad_time_string(seconds);
                    milliseconds = wp.smartplugins.admin.pad_time_string(milliseconds);

                    var currentTimeString = hours + ":" + minutes + ":" + seconds + "." + milliseconds;

                    $("#sct-load-timer").html(currentTimeString);
                }, 400);
            }
        },
        tabs: function() {
            $(document).on("click", ".spw-tabs-list li a", function(e) {
                e.preventDefault();

                $(".spw-tabs-list li").removeClass("sct-current-tab");
                $(this).parent().addClass("sct-current-tab");

                $(".spw-tabs-content .spw-tab").removeClass("sct-current-content");
                $($(this).attr("href")).addClass("sct-current-content");
            });
        },
        dim: {
            open: function() {
                $(".sct-dim").show();
                $("html").css("overflow", "hidden");
                wp.smartplugins.admin.current = new Date();
            },
            close: function() {
                $(".sct-dim").hide();
                $("html").css("overflow", "auto");
            }
        },
        panels: {
            customers: function() {
                $("#sbv-dialog-code-details").wpdialog({
                    bgiframe: true, autoResize: true, resizable: true, modal: true,
                    width: 680, autoOpen: false, closeOnEscape: true, autoHeight: true,
                    buttons: {
                        OK: function() {
                            $(this).wpdialog("close");
                        }
                    }
                });

                $("#sbv-dialog-code-removal").wpdialog({
                    bgiframe: true, autoResize: false, resizable: false, modal: true,
                    width: 480, autoOpen: false, closeOnEscape: true, autoHeight: true,
                    buttons: [{
                        text: "Remove",
                        click: function() {
                            window.location.href = wp.smartplugins.admin.removal;
                        }
                    }, {
                        text: "Close",
                        click: function() {
                            $(this).wpdialog("close");
                        }
                    }
                    ]
                });

                $(document).on("click", ".sbv-view-code-remove", function(e) {
                    e.preventDefault();

                    wp.smartplugins.admin.removal = $(this).attr("href");

                    var code = $(this).data("code");

                    $("#sbv-remove-code-placeholder").html(code);
                    $("#sbv-dialog-code-removal").wpdialog("open");
                });

                $(document).on("click", ".sbv-view-code-data", function(e) {
                    e.preventDefault();

                    var id = $(this).attr("href").substring(1);

                    $("#sbv-code-details-content").html($("#envato-code-" + id).html());
                    $("#sbv-dialog-code-details").wpdialog("open");
                });
            }
        }
    };

    $(document).ready(function() {
        wp.smartplugins.admin.init();
        wp.smartplugins.admin.tabs();
    });
})(jQuery, window, document);
