<form method="post" action="">
	<?php settings_fields( 'smart-bbpress-nverify-tools' ); ?>

    <div class="spw-panel-two-columns">
        <div class="spw-column-left">
            <p>
				<?php esc_html_e( 'With these tools you can perform maintenance of the plugin cached API results and stored data.', 'smart-bbpress-nverify' ); ?>
            </p>
            <input type="submit" class="button-primary" value="<?php esc_attr_e( 'Execute', 'smart-bbpress-nverify' ); ?>"/>
        </div>
        <div class="spw-column-right">
            <h3><?php esc_html_e( 'Cached API results', 'smart-bbpress-nverify' ); ?></h3>
            <table class="form-table">
                <tbody>
                <tr>
                    <th scope="row"><?php esc_html_e( 'Clear all cached data', 'smart-bbpress-nverify' ); ?></th>
                    <td>
                        <fieldset>
                            <legend class="screen-reader-text">
                                <span><?php esc_html_e( 'Clear all cached data', 'smart-bbpress-nverify' ); ?></span>
                            </legend>
                            <label for="cache_active">
                                <input type="checkbox" value="1" id="cache_clear" name="sbv[cache_clear]">
								<?php esc_html_e( 'Active', 'smart-bbpress-nverify' ); ?></label>

                            <br/><em>
								<?php esc_html_e( 'With this tool you can remove all data cached by this plugin from the database. This is a safe operation, and it will force plugin to reload data using Envato API.', 'smart-bbpress-nverify' ); ?>
                            </em>
                        </fieldset>
                    </td>
                </tr>
                </tbody>
            </table>

            <h3><?php esc_html_e( 'Error Log File', 'smart-bbpress-nverify' ); ?></h3>
            <table class="form-table">
                <tbody>
                <tr>
                    <th scope="row"><?php esc_html_e( 'Clear all logged errors', 'smart-bbpress-nverify' ); ?></th>
                    <td>
                        <fieldset>
                            <legend class="screen-reader-text">
                                <span><?php esc_html_e( 'Clear all logged errors', 'smart-bbpress-nverify' ); ?></span>
                            </legend>
                            <label for="cache_active">
                                <input type="checkbox" value="1" id="cache_clear" name="sbv[log_clear]">
								<?php esc_html_e( 'Active', 'smart-bbpress-nverify' ); ?></label>

                            <br/><em>
								<?php esc_html_e( 'With this tool you can purge error log file from all logged errors.', 'smart-bbpress-nverify' ); ?>
                            </em>
                        </fieldset>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</form>
