<h3><?php esc_html_e( 'Protected Forum Access Control', 'smart-bbpress-nverify' ); ?></h3>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row"><?php esc_html_e( 'Forum', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Forum', 'smart-bbpress-nverify' ); ?></span>
                </legend>
                <label for="access_control_forum">
                    <input<?php echo $settings['access_control_forum'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="access_control_forum" name="sbv[access_control_forum]">
					<?php esc_html_e( 'Protect', 'smart-bbpress-nverify' ); ?></label>

                <br/><em>
					<?php esc_html_e( 'List of topics in protected forum require purchase code validation.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'Topic', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Topic', 'smart-bbpress-nverify' ); ?></span>
                </legend>
                <label for="access_control_topic">
                    <input<?php echo $settings['access_control_topic'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="access_control_topic" name="sbv[access_control_topic]">
					<?php esc_html_e( 'Protect', 'smart-bbpress-nverify' ); ?></label>

                <br/><em>
					<?php esc_html_e( 'Individual topics in protected forum require purchase code validation. It is recommended to leave this option on, or anyone will be able to access protected topics.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'Reply', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Reply', 'smart-bbpress-nverify' ); ?></span>
                </legend>
                <label for="access_control_reply">
                    <input<?php echo $settings['access_control_reply'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="access_control_reply" name="sbv[access_control_reply]">
					<?php esc_html_e( 'Protect', 'smart-bbpress-nverify' ); ?></label>

                <br/><em>
					<?php esc_html_e( 'This option will protect replies displayed in user profile and other places, outside of the topic thread.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'New Topic Form', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'New Topic Form', 'smart-bbpress-nverify' ); ?></span></legend>
                <label for="access_control_new_topic">
                    <input<?php echo $settings['access_control_new_topic'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="access_control_new_topic" name="sbv[access_control_new_topic]">
					<?php esc_html_e( 'Protect', 'smart-bbpress-nverify' ); ?></label>

                <br/><em>
					<?php esc_html_e( 'If you disable Forum protection, this will ensure than form for creating new topic in protected forum is not accessible until purchase code is verified.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'New Topic Form with Forum Selection', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'New Topic Form with Forum Selection', 'smart-bbpress-nverify' ); ?></span></legend>
                <label for="access_control_new_topic_noforum">
                    <input<?php echo $settings['access_control_new_topic_noforum'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="access_control_new_topic_noforum" name="sbv[access_control_new_topic_noforum]">
					<?php esc_html_e( 'Protect', 'smart-bbpress-nverify' ); ?></label>

                <br/><em>
					<?php esc_html_e( 'New topic form can be set to allow user selecting Forum to post into. In this case, normal topic form protection will not work. But, with this option, plugin will attempt to check data after submission and display message as submission error.', 'smart-bbpress-nverify' ); ?>
                    <br/>
					<?php esc_html_e( 'This option should be used only if you add new topic form using shortcode where user needs to select forum from drop down list. In all other cases, disable this option.', 'smart-bbpress-nverify' ); ?>
                </em>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'New Reply Form', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'New Topic Form', 'smart-bbpress-nverify' ); ?></span></legend>
                <label for="access_control_new_reply">
                    <input<?php echo $settings['access_control_new_reply'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="access_control_new_reply" name="sbv[access_control_new_reply]">
					<?php esc_html_e( 'Protect', 'smart-bbpress-nverify' ); ?></label>

                <br/><em>
					<?php esc_html_e( 'If you disable Topic protection, this will ensure than form for creating new reply in protected forum or topic is not accessible until purchase code is verified.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'Search Results', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Search Results', 'smart-bbpress-nverify' ); ?></span></legend>
                <label for="access_control_forum">
                    <input<?php echo $settings['access_control_search'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="access_control_search" name="sbv[access_control_search]">
					<?php esc_html_e( 'Protect', 'smart-bbpress-nverify' ); ?></label>

                <br/><em>
					<?php esc_html_e( 'Individual search results will be replaced with the message if the access is not allowed.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    </tbody>
</table>

<h3><?php esc_html_e( 'Unrestricted Forum Access Control', 'smart-bbpress-nverify' ); ?></h3>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row"><?php esc_html_e( 'User Roles', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'User Roles', 'smart-bbpress-nverify' ); ?></span>
                </legend>
				<?php

				global $wp_roles;

				foreach ( $wp_roles->roles as $role => $obj ) {
					$sel = in_array( $role, $settings['access_unrestriced_user_roles'] ) ? ' checked="checked"' : '';
					echo '<label><input type="checkbox" value="' . $role . '"' . $sel . ' name="sbv[access_unrestriced_user_roles][]" />' . $obj['name'] . '</label><br/>';
				}

				?>

                <em style="display: block; margin-top: 8px;">
					<?php esc_html_e( 'Users that belong to selected user roles will have unrestricted access to protected forum. Regular users usually have \'Subscriber\' and \'Participant\' roles, so it is not recommended to grand unrestricted access to those roles.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    </tbody>
</table>
