<h3><?php esc_html_e( 'Purchase Code Validation', 'smart-bbpress-nverify' ); ?></h3>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row"><?php esc_html_e( 'Code unique for single user', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Code unique for single user', 'smart-bbpress-nverify' ); ?></span></legend>
                <label for="verify_unique_purchase_code">
                    <input<?php echo $settings['verify_unique_purchase_code'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="verify_unique_purchase_code" name="sbv[verify_unique_purchase_code]">
					<?php esc_html_e( 'Active', 'smart-bbpress-nverify' ); ?></label>

                <br/><em>
					<?php esc_html_e( 'Only one user on your website can register single purchase code. This will prevent reuse of purchase code by multiple users.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    </tbody>
</table>

<h3><?php esc_html_e( 'Automatic Purchase Codes Revalidation', 'smart-bbpress-nverify' ); ?></h3>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row"><?php esc_html_e( 'Revalidate purchase codes', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Revalidate purchase codes', 'smart-bbpress-nverify' ); ?></span></legend>
                <label for="revalidate_purchase_code">
                    <input<?php echo $settings['revalidate_purchase_code'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="revalidate_purchase_code" name="sbv[revalidate_purchase_code]">
					<?php esc_html_e( 'Active', 'smart-bbpress-nverify' ); ?></label>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'Revalidation period', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Revalidation period', 'smart-bbpress-nverify' ); ?></span></legend>
                <input type="number" min="0" step="1" class="widefat" name="sbv[revalidate_period_days]" value="<?php echo $settings['revalidate_period_days']; ?>" style="width: 128px;"/> [<?php esc_html_e( 'days', 'smart-bbpress-nverify' ); ?>]

                <em style="display: block; margin-top: 8px;">
					<?php esc_html_e( 'In case purchase is reversed or refunded, purchase code will no longer be valid. This option will revalidate purchase code after specified number of days to make sure user registering purchase code is still allowed to use the code.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    </tbody>
</table>
