<h3><?php esc_html_e( 'Item Support', 'smart-bbpress-nverify' ); ?></h3>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row"><?php esc_html_e( 'Support', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Support', 'smart-bbpress-nverify' ); ?></span>
                </legend>
                <label for="global_support">
                    <input<?php echo $settings['global_support'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="global_support" name="sbv[global_support]">
					<?php esc_html_e( 'Use support status for each item to limit support access', 'smart-bbpress-nverify' ); ?>
                </label>

                <br/><em>
					<?php esc_html_e( 'For this to work properly, you need to have revalidation feature enabled to periodically check if the support has expired or not.', 'smart-bbpress-nverify' ); ?>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'Old purchases', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Old purchases', 'smart-bbpress-nverify' ); ?></span>
                </legend>
                <label for="global_support_september">
                    <input<?php echo $settings['global_support_september'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="global_support_september" name="sbv[global_support_september]">
					<?php esc_html_e( 'Disable support check for purchase made before September 1, 2015', 'smart-bbpress-nverify' ); ?>
                </label>

                <br/><em>
					<?php esc_html_e( 'Envato support policy is in effect since September 1, 2015. If you offered lifetime support before that, you can enable this option, and plugin will not check support expiration for these old purchases.', 'smart-bbpress-nverify' ); ?>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'Retired items', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Retired items', 'smart-bbpress-nverify' ); ?></span>
                </legend>
                <label for="global_support_retired">
                    <input<?php echo $settings['global_support_retired'] ? ' checked="checked"' : ''; ?> type="checkbox" value="1" id="global_support_retired" name="sbv[global_support_retired]">
					<?php esc_html_e( 'Treat all retired items as supported', 'smart-bbpress-nverify' ); ?></label>

                <br/><em>
					<?php esc_html_e( 'If your item is retired or disabled, users can\'t extend support anymore. You can choose to set all those items as supported by enabling this option.', 'smart-bbpress-nverify' ); ?>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'Recheck delay', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Recheck delay', 'smart-bbpress-nverify' ); ?></span>
                </legend>
                <input type="number" min="0" step="1" class="widefat" name="sbv[global_support_period]" value="<?php echo $settings['global_support_period']; ?>" style="width: 128px;"/> [<?php esc_html_e( 'minutes', 'smart-bbpress-nverify' ); ?>]

                <em style="display: block; margin-top: 8px;">
					<?php esc_html_e( 'To prevent quick recheck in case of the support period expiration, this value will ensure not making too many recheck calls too soon.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    </tbody>
</table>

<h3><?php esc_html_e( 'Skip support check for selected items', 'smart-bbpress-nverify' ); ?></h3>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row"><?php esc_html_e( 'Items', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Items', 'smart-bbpress-nverify' ); ?></span>
                </legend>
                <input type="text" class="widefat" name="sbv[global_support_exceptions]" value="<?php echo join( ', ', $settings['global_support_exceptions'] ); ?>"/>

                <br/><em>
					<?php esc_html_e( 'Comma separated list of item ID\'s.', 'smart-bbpress-nverify' ); ?>
					<?php esc_html_e( 'Support expiration will not be checked for any of the items on this list.', 'smart-bbpress-nverify' ); ?></em>
            </fieldset>
        </td>
    </tr>
    </tbody>
</table>
