<h3><?php esc_html_e( 'Main Author Account', 'smart-bbpress-nverify' ); ?></h3>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row"><?php esc_html_e( 'Envato Username', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Envato Username', 'smart-bbpress-nverify' ); ?></span></legend>
                <input type="text" class="widefat" name="sbv[global_user_name]" value="<?php echo $settings['global_user_name']; ?>"/>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'Personal API Token', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_html_e( 'Personal API Token', 'smart-bbpress-nverify' ); ?></span></legend>
                <input id="apikey-password" type="password" class="widefat" name="sbv[global_api_token]" value="<?php echo $settings['global_api_token']; ?>"/>

                <br/><em>
					<?php esc_html_e( 'If you switch to New API, you need to enter Personal Token. To do that, sign into Envato API website, and create new token. Paste the token into the field here.', 'smart-bbpress-nverify' ); ?>
					<?php esc_html_e( 'The token must have at least these permissions enabled', 'smart-bbpress-nverify' ); ?>:
                    View and search Envato sites, View your Envato Account username, View your email address, View your account profile details, Verify purchases of your items

                    <br/><br/>
					<?php esc_html_e( 'Envato API', 'smart-bbpress-nverify' ); ?>:
                    <a href="https://build.envato.com/" target="_blank"><?php esc_html_e( 'Start Page', 'smart-bbpress-nverify' ); ?></a> &middot;
                    <a href="https://build.envato.com/create-token" target="_blank"><?php esc_html_e( 'Create Personal Token', 'smart-bbpress-nverify' ); ?></a>
                </em>
            </fieldset>
        </td>
    </tr>
    <tr>
        <th scope="row"><?php esc_html_e( 'Status', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Status', 'smart-bbpress-nverify' ); ?></span>
                </legend>
				<?php

				if ( $settings['global_user_name'] == '' || $settings['global_api_token'] == '' ) {
					echo '<strong style="color: #c40000;">';
					_e( 'Both username and API token are required.', 'smart-bbpress-nverify' );
					echo '</strong>';
				} else {
					if ( sbv_api()->is_online() ) {
						$result = sbv_api()->is_account_set();

						if ( is_wp_error( $result ) ) {
							echo '<strong style="color: #c40000;">';
							echo join( '<br/>', $result->get_error_messages() );
							echo '</strong>';
						} else {
							echo '<strong style="color: #007700;">';
							_e( 'Your account is set correctly.', 'smart-bbpress-nverify' );
							echo '</strong>';
						}
					} else {
						echo '<strong style="color: #ee0000;">';
						_e( 'Envato API can\'t be reached at this time, please wait few minutes before trying again.', 'smart-bbpress-nverify' );
						echo '</strong>';
					}
				}

				?>
            </fieldset>
        </td>
    </tr>
    </tbody>
</table>

<h3><?php esc_html_e( 'Your Default Marketplace', 'smart-bbpress-nverify' ); ?></h3>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row"><?php esc_html_e( 'Marketplace', 'smart-bbpress-nverify' ); ?></th>
        <td>
            <fieldset>
                <legend class="screen-reader-text"><span><?php esc_html_e( 'Marketplace', 'smart-bbpress-nverify' ); ?></span>
                </legend>
                <select class="widefat" name="sbv[global_marketplace]">
					<?php

					foreach ( sbv_api()->marketplaces() as $key => $title ) {
						$selected = $settings['global_marketplace'] == $key ? ' selected="selected"' : '';
						echo '<option value="' . $key . '"' . $selected . '>' . $title . '</option>';
					}

					?>
                </select>
            </fieldset>
        </td>
    </tr>
    </tbody>
</table>
