<?php

function sbv_admin_render_item( $item = array(), $id = 0, $display = "block", $multi_account = false, $check_support = false ) {
	$default = array(
		'item'     => '',
		'author'   => 'global',
		'username' => '',
		'api_key'  => '',
		'status'   => '',
		'support'  => 'auto',
	);

	$item = wp_parse_args( $item, $default );

	if ( $multi_account === false ) {
		$item['author'] = 'global';
	}

	?>
    <div class="sbv-meta-item<?php echo $display == 'none' ? ' sbv-meta-default-item' : ''; ?>" style="display: <?php echo $display; ?>">
        <p>
            <label><?php esc_html_e( 'Item ID', 'smart-bbpress-nverify' ); ?>:</label><input name="sbvitem[<?php echo $id; ?>][item]" value="<?php echo $item['item']; ?>" type="text"/>
        </p>
		<?php if ( $check_support ) { ?>
            <p>
                <label><?php esc_html_e( 'Support', 'smart-bbpress-nverify' ); ?>:</label><select name="sbvitem[<?php echo $id; ?>][support]">
                    <option value="auto"<?php echo $item['support'] == 'auto' ? ' selected="selected"' : ''; ?>><?php esc_html_e( 'Check', 'smart-bbpress-nverify' ); ?></option>
                    <option value="no"<?php echo $item['support'] == 'no' ? ' selected="selected"' : ''; ?>><?php esc_html_e( 'Don\'t Check', 'smart-bbpress-nverify' ); ?></option>
                </select>
            </p>
		<?php } else { ?>
            <input name="sbvitem[<?php echo $id; ?>][support]" value="<?php echo $item['support']; ?>" type="hidden"/>
		<?php } ?>
        <p style="display: <?php echo $multi_account ? 'display' : 'none'; ?>">
            <label><?php esc_html_e( 'Author', 'smart-bbpress-nverify' ); ?>:</label><select class="sbvitem-author-select" name="sbvitem[<?php echo $id; ?>][author]">
                <option value="global"<?php echo $item['author'] == 'global' ? ' selected="selected"' : ''; ?>><?php esc_html_e( 'Global', 'smart-bbpress-nverify' ); ?></option>
                <option value="custom"<?php echo $item['author'] == 'custom' ? ' selected="selected"' : ''; ?>><?php esc_html_e( 'Custom', 'smart-bbpress-nverify' ); ?></option>
            </select>
        </p>
        <div class="sbv-meta-item-custom" style="display: <?php echo $item['author'] == 'global' ? 'none' : 'display'; ?>">
            <p>
                <label><?php esc_html_e( 'Username', 'smart-bbpress-nverify' ); ?>:</label><input name="sbvitem[<?php echo $id; ?>][username]" value="<?php echo $item['username']; ?>" type="text"/>
            </p>
            <p>
                <label><?php esc_html_e( 'API Token', 'smart-bbpress-nverify' ); ?>:</label><input name="sbvitem[<?php echo $id; ?>][api_key]" value="<?php echo $item['api_key']; ?>" type="text"/>
            </p>
        </div>

		<?php if ( $item['item'] != '' ) {
			echo '<div class="sbv-meta-item-status">';

			if ( $item['status'] == 'error' ) {
				echo '<strong style="color: #c40000;">' . esc_html__( 'Specified item is invalid.', 'smart-bbpress-nverify' ) . '</strong>';
			} else {
				if ( $item['author'] == 'custom' ) {
					sbv_api()->access_custom( $item['username'], $item['api_key'] );
				}

				$envato = sbv_api()->item( $item['item'] );

				if ( isset( $envato->url ) ) {
					echo esc_html__( 'Item is valid', 'smart-bbpress-nverify' ) . ': <a style="font-weight: bold; color: #007700;" href="' . $envato->url . '" target="_blank">' . $envato->item . '</a>.';
				} else {
					echo esc_html__( 'Item not found.', 'smart-bbpress-nverify' );
				}

				$brk = explode( '.', $item['status'] );

				if ( $brk[1] == 'wrong' ) {
					echo '<br/><strong style="color: #c40000;">' . esc_html__( 'Item author is wrong.', 'smart-bbpress-nverify' ) . '</strong>';
				}
			}

			echo '</div>';
		} ?>

        <a class="sbv-meta-remove-item" href="#"><?php esc_html_e( 'Remove This Item', 'smart-bbpress-nverify' ); ?></a>
    </div>
<?php }

$forum_id = sbv_forum_get_id();
$items    = sbv_forum_get_envato_items();

$support = apply_filters( 'sbv_check_support_status', smart_sbv_core()->get( 'global_support' ) );

?>
<div class="sbv-meta-select">
    <label><?php esc_html_e( 'Select Protection Method', 'smart-bbpress-nverify' ); ?>:</label>
    <select name="sbvmethod">
        <option<?php if ( $items['method'] == 'items' ) {
			echo ' selected="selected"';
		} ?> value="items"><?php esc_html_e( 'Individual Items', 'smart-bbpress-nverify' ); ?></option>
        <option<?php if ( $items['method'] == 'account' ) {
			echo ' selected="selected"';
		} ?> value="account"><?php esc_html_e( 'Any Item for main Account', 'smart-bbpress-nverify' ); ?></option>
    </select>
</div>

<div class="sbv-meta-account"<?php if ( $items['method'] == 'items' ) {
	echo ' style="display: none"';
} ?>>
	<?php esc_html_e( 'User needs to enter purchase ID for any item belonging to your account.', 'smart-bbpress-nverify' ); ?>
</div>
<div class="sbv-meta-items"<?php if ( $items['method'] == 'account' ) {
	echo ' style="display: none"';
} ?>>
    <a id="sbv-meta-add-new-item" href="#" class="preview button"><?php esc_html_e( 'Add New Item', 'smart-bbpress-nverify' ); ?></a>

    <div class="clear"></div>

	<?php sbv_admin_render_item( array(), 0, 'none', smart_sbv_core()->get( 'allow_multiple_users' ), $support ); ?>

    <div id="sbv-meta-items-list">
		<?php

		$id = 1;
		foreach ( $items['items'] as $item ) {
			sbv_admin_render_item( $item, $id, 'block', smart_sbv_core()->get( 'allow_multiple_users' ), $support );

			$id ++;
		}

		?>
    </div>
</div>

<input type="hidden" value="<?php echo $id; ?>" id="sbv-meta-item-id"/>
<input type="hidden" value="<?php echo wp_create_nonce( 'smart-bbpress-nverify' ); ?>" name="sbv-meta-items"/>
