<?php

$current = isset( $_GET['tab'] ) ? sanitize_key( $_GET['tab'] ) : 'settings';

$tabs = array(
	'settings'  => array( esc_html__( 'Settings', 'smart-bbpress-nverify' ), '__inner__' ),
	'customers' => array( esc_html__( 'Customers', 'smart-bbpress-nverify' ), '__inner__' ),
	'verify'    => array( esc_html__( 'Quick Verify', 'smart-bbpress-nverify' ), '__inner__' ),
	'errors'    => array( esc_html__( 'Error Log', 'smart-bbpress-nverify' ), '__inner__' ),
	'tools'     => array( esc_html__( 'Tools', 'smart-bbpress-nverify' ), '__inner__' ),
);

$tabs = apply_filters( 'sbv_admin_tabs_list', $tabs );

$tabs['about'] = array( esc_html__( 'About', 'smart-bbpress-nverify' ), '__inner__' );

if ( ! isset( $tabs[ $current ] ) ) {
	$current = 'settings';
}

?>

<div class="wrap smart-plugin-wrapper spw-wordpress-<?php echo SBV_WP_VERSION; ?>">
    <h1><span class="spw-dashicons dashicons dashicons-lock"></span>
		<?php esc_html_e( 'Smart bbPress nVerify', 'smart-bbpress-nverify' ); ?>
        <span class="sct-version"> | <?php echo smart_sbv_core()->get( '__version__' ); ?></span></h1>
	<?php if ( isset( $_GET['settings-updated'] ) ) { ?>
        <div id="message" class="updated"><p><strong><?php esc_html_e( 'Settings saved.', 'smart-bbpress-nverify' ); ?></strong>
            </p></div>
	<?php }
	if ( isset( $_GET['cache-cleared'] ) ) { ?>
        <div id="message" class="updated"><p>
                <strong><?php esc_html_e( 'All cached data is now removed.', 'smart-bbpress-nverify' ); ?></strong></p></div>
	<?php }
	if ( isset( $_GET['log-cleared'] ) ) { ?>
        <div id="message" class="updated"><p>
                <strong><?php esc_html_e( 'Error log file is removed.', 'smart-bbpress-nverify' ); ?></strong></p></div>
	<?php }
	if ( isset( $_GET['unlink-done'] ) ) { ?>
        <div id="message" class="updated"><p>
                <strong><?php esc_html_e( 'Purchase code is removed from the system.', 'smart-bbpress-nverify' ); ?></strong>
            </p></div>
	<?php }
	if ( isset( $_GET['revalidation-done'] ) ) { ?>
        <div id="message" class="updated"><p>
                <strong><?php esc_html_e( 'Purchase codes for selected user are revalidated.', 'smart-bbpress-nverify' ); ?></strong>
            </p></div>
	<?php } ?>
    <h2 class="nav-tab-wrapper">
		<?php

		foreach ( $tabs as $tab => $data ) {
			$class = $tab == $current ? ' nav-tab-active' : '';
			echo '<a class="nav-tab' . $class . '" href="' . $this->admin_page_url . '?page=smart-bbpress-nverify&tab=' . $tab . '">' . $data[0] . '</a>';
		}

		?>
    </h2>
    <div id="smart-plugin-panel" class="spw-panel-wrapper spw-panel-<?php echo $current; ?>">
		<?php

		$location = $tabs[ $current ][1];

		if ( $location == '__inner__' ) {
			include( SBV_PATH . 'forms/' . $current . '.php' );
		} else {
			include( $location );
		}

		?>
    </div>
</div>