<?php

require_once( SBV_PATH . 'api/envato.api.php' );

$api   = new smart_envato_api_build( 'codecanyon' );
$files = $api->data( 172800 )
             ->token( '7XQEBuOydU1BDc0SRLw1TzvFA5FL3GMS' )
             ->referrer( 'SMARTPlugins' )
             ->affiliate( array( 'id' => '1210711', 'ad' => '523004' ) )
             ->new_files_from_user( 'SMARTPlugins', 'codecanyon' );

function sct_render_item_about( $item ) : string {
	$max_width     = 5 * 24;
	$current_width = $item->rating * 24;
	$uploaded_on   = strtotime( $item->uploaded_on );
	$last_update   = strtotime( $item->last_update );

	$render = '<div class="sct-about-item sct-about-item-' . $item->id . '">';
	$render .= '<a href="' . $item->url() . '" target="_blank"><img class="sct-about-item-image" src="' . $item->thumbnail . '" alt="' . esc_attr( $item->item ) . '" /></a>';
	$render .= '<div class="sct-about-item-content">';
	$render .= '<h4 class="sct-about-item-title"><a href="' . $item->url() . '" target="_blank">' . $item->item . '</a></h4>';
	$render .= '<div class="sct-about-item-meta">';
	$render .= '<div class="sct-about-stars" style="width:' . $max_width . 'px"><div class="sct-about-stars sct-about-stars-on" style="width:' . $current_width . 'px"></div></div>';

	$render .= '<div class="sct-about-item-meta-price">';
	$render .= '<span class="sct-about-item-meta-cost">$' . $item->cost . '</span>';
	$render .= '<span class="sct-about-item-meta-sales">' . $item->sales . ' ' . _n( 'sale', 'sales', $item->sales, 'smart-bbpress-nverify' ) . '</span>';
	$render .= '</div>';
	$render .= '</div>';
	$render .= '</div>';
	$render .= '<div class="sct-about-item-extra">';
	$render .= esc_html__( 'uploaded on', 'smart-bbpress-nverify' ) . ': <strong>' . date( get_option( 'date_format' ), $uploaded_on ) . '</strong><br/>';
	$render .= esc_html__( 'last update', 'smart-bbpress-nverify' ) . ': <strong>' . date( get_option( 'date_format' ), $last_update ) . '</strong>';
	$render .= '</div>';
	$render .= '</div>';

	return $render;
}

?>
<div class="spw-panel-two-columns">
    <div class="spw-column-left">
        <p>
			<?php _e( 'Integrate with bbPress forums to implement verification of the Envato purchase codes. Assign one or more Envato items to forums for purchase only access.', 'smart-bbpress-nverify' ); ?>
        </p>
        <div class="spw-info-box">
            <h3><?php _e( 'About Plugin', 'smart-bbpress-nverify' ); ?></h3>
			<?php

			echo esc_html__( 'Version', 'smart-bbpress-nverify' ) . ': <strong>' . $about['__version__'] . '</strong><br/>';
			echo esc_html__( 'Date', 'smart-bbpress-nverify' ) . ': <strong>' . $about['__date__'] . '</strong><br/>';
			echo esc_html__( 'Build', 'smart-bbpress-nverify' ) . ': <strong>' . $about['__build__'] . '</strong>';

			?>
        </div>
        <div class="spw-info-box">
            <h3><?php _e( 'SMARTPlugins', 'smart-bbpress-nverify' ); ?></h3>
            <a href="https://www.smartplugins.info/" target="_blank">SMARTPlugins Home</a>
            and on <a href="https://1.envato.market/xzxL5" target="_blank">CodeCanyon</a>
        </div>
    </div>
    <div class="spw-column-right">
		<?php if ( ! is_wp_error( $files ) ) { ?>
            <div class="spw-about-plugins">
				<?php

				foreach ( $files as $file ) {
					echo sct_render_item_about( $file );
				}

				?>
            </div>
		<?php } ?>
    </div>
</div>
