<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class sbv_loader {
	public $settings = array();

	function __construct() {
		global $wp_version;

		define( 'SBV_WPV', $wp_version );
		define( 'SBV_WP_VERSION', intval( substr( str_replace( '.', '', $wp_version ), 0, 2 ) ) );

		add_action( 'plugins_loaded', array( $this, 'init_plugin_settings' ), 9 );
		add_action( 'plugins_loaded', array( $this, 'init_translation' ) );
	}

	public static function instance() : sbv_loader {
		static $instance = null;

		if ( ! isset( $instance ) ) {
			$instance = new sbv_loader();
		}

		return $instance;
	}

	public function init_translation() {
		if ( ! empty( get_locale() ) ) {
			load_plugin_textdomain( 'smart-bbpress-nverify', false, 'smart-bbpress-nverify/languages' );
		}
	}

	public function init_plugin_settings() {
		$_d = new sbv_defaults();

		$this->settings = get_option( 'smart-bbpress-nverify' );

		$clear_cache = false;

		if ( ! is_array( $this->settings ) ) {
			$this->settings = $_d->settings;
			update_option( 'smart-bbpress-nverify', $this->settings );

			$clear_cache = true;
		} else if ( $this->settings['__build__'] != $_d->settings['__build__'] ) {
			$this->settings = $_d->upgrade( $this->settings );
			update_option( 'smart-bbpress-nverify', $this->settings );

			$clear_cache = true;
		}

		define( 'SMART_BBPRESS_NVERIFY', $this->settings['__version__'] );

		require_once( SBV_PATH . 'core/objects/api.php' );

		if ( $clear_cache ) {
			sbv_api()->clear_cache();
		}

		do_action( 'sbv_init_plugin_settings' );
	}

	public function get( $name ) {
		return $this->settings[ $name ];
	}

	public function set( $name, $value ) {
		$this->settings[ $name ] = $value;
	}

	public function save() {
		update_option( 'smart-bbpress-nverify', $this->settings );
	}
}
