<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class sbv_api_loader {
	public $object;

	public function __construct() {
		require_once( SBV_PATH . 'api/envato.api.php' );

		$this->object = new smart_envato_api_build( smart_sbv_core()->get( 'global_marketplace' ) );

		$this->object->set_token( smart_sbv_core()->get( 'global_api_token' ) );
		$this->object->set_username( smart_sbv_core()->get( 'global_user_name' ) );
		$this->object->set_referrer( smart_sbv_core()->get( 'global_user_name' ) );
		$this->object->affiliate( array(
			'affiliate' => smart_sbv_core()->get( 'impact_affiliate' ),
			'id'        => smart_sbv_core()->get( 'impact_id' ),
			'ad'        => smart_sbv_core()->get( 'impact_ad' ),
		) );

		$this->object->enable_normalization();
	}

	public function access_custom( $user_name, $api_key ) {
		$this->object->set_username( $user_name );
		$this->object->set_token( $api_key );
	}

	public function access_default() {
		$this->object->set_username( smart_sbv_core()->get( 'global_user_name' ) );
		$this->object->set_token( smart_sbv_core()->get( 'global_api_token' ) );
	}

	public function is_account_set() {
		return $this->vitals();
	}

	public function data( $ttl = 0, $use_cache = true ) {
		$this->object->data( $ttl, $use_cache );
	}

	public function clear_cache() {
		$this->object->clear_cache();
	}

	public function is_online( $force = false ) {
		$_transient = get_site_transient( 'sbv_envato_api_online_status' );

		if ( $_transient === false || $force ) {
			$status = $this->total_items();
			$online = true;

			if ( is_wp_error( $status ) ) {
				$errors = $status->get_error_codes();

				if ( ! in_array( 'forbidden', $errors ) ) {
					$online = false;
				}
			}

			$_transient = $online ? 'online' : 'offline';

			set_site_transient( 'sbv_envato_api_online_status', $_transient, 120 );
		} else {
			$online = $_transient === 'online';
		}

		return apply_filters( 'sbv_envato_api_is_online', $online );
	}

	public function total_items() {
		return $this->object->api( 'total-items' );
	}

	public function vitals() {
		return $this->object->vitals();
	}

	public function marketplaces() {
		return $this->object->marketplaces;
	}

	public function verify_purchase( $purchase_code ) {
		return $this->object->verify_purchase( $purchase_code );
	}

	public function item( $item_id ) {
		return $this->object->item( $item_id );
	}

	public function user( $username ) {
		return $this->object->user( $username );
	}

	public function get_log_file_contents() {
		return $this->object->get_log_file_contents();
	}
}

global $sbv_api_loader;
$sbv_api_loader = new sbv_api_loader();

function sbv_api() {
	global $sbv_api_loader;

	return $sbv_api_loader;
}
