<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function sbv_show_notice( $text, $type = '' ) {
	echo '<div class="bbp-template-notice' . ( $type != '' ? ' ' . $type : '' ) . '">';
	echo '<p>' . esc_html( $text ) . '</p>';
	echo '</div>';
}

function sbv_render_account_link( $account = '', $echo = true ) {
	$account_name = $account != '' ? $account : smart_sbv_core()->get( 'global_user_name' );
	$marketplace  = smart_sbv_core()->get( 'global_marketplace' );

	$user = sbv_api()->user( $account_name );

	$render = '<a href="' . $user->url( $marketplace ) . '" target="_blank">' . esc_html( $user->username ) . '</a>';

	if ( $echo ) {
		echo $render;
	}

	return $render;
}

function sbv_render_account( $account = '' ) {
	$account_name = $account != '' ? $account : smart_sbv_core()->get( 'global_user_name' );
	$marketplace  = smart_sbv_core()->get( 'global_marketplace' );

	$user = sbv_api()->user( $account_name );

	echo '<div class="sbv-envato-item">';
	echo '<a href="' . $user->url( $marketplace ) . '" target="_blank">';
	echo '<img src="' . $user->image . '" alt="' . esc_attr( $user->username ) . '" />';
	echo '</a>';
	echo '<div>';
	echo '<h4><a href="' . $user->url( $marketplace ) . '" target="_blank">' . $user->username . '</a></h4>';
	echo '<em>' . esc_html__( 'sales', 'smart-bbpress-nverify' ) . ' ' . $user->sales . ', ' . esc_html__( 'followers', 'smart-bbpress-nverify' ) . ' ' . $user->followers . '</em>';
	echo '</div>';
	echo '</div>';
}

function sbv_render_item( $item ) {
	echo '<div class="sbv-envato-item">';

	if ( ! empty( $item->url ) ) {
		echo '<a href="' . $item->url() . '" target="_blank">';
		echo '<img src="' . $item->thumbnail . '" alt="' . esc_attr( $item->item ) . '" />';
		echo '</a>';
		echo '<div>';
		echo '<h4><a href="' . $item->url() . '" target="_blank">' . $item->item . '</a></h4>';
		echo '<em>' . esc_html__( 'by', 'smart-bbpress-nverify' ) . ' ' . sbv_render_account_link( $item->user, false ) . '</em>';
		echo '</div>';
	} else {
		echo '<div><h4>' . esc_html__( 'Item ID', 'smart-bbpress-nverify' ) . ': ' . $item->id . '</h4></div>';
	}

	echo '</div>';
}
