<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function smart_sbv_core() : sbv_loader {
	return sbv_loader::instance();
}

function sbv_validator() : sbv_validator {
	return sbv_validator::instance();
}

function sbv_bbpress() : sbv_bbpress {
	return sbv_bbpress::instance();
}

function sbv_check_forum_access( $forum_id = 0, $type = 'custom' ) : bool {
	return sbv_bbpress()->check( $type, $forum_id );
}

function sbv_forum_get_id( $forum_id = 0 ) {
	if ( is_admin() ) {
		if ( $forum_id == 0 ) {
			global $post;

			$forum_id = $post->ID;
		}

		return $forum_id;
	} else {
		return bbp_get_forum_id( $forum_id );
	}
}

function sbv_forum_get_envato_items( $forum_id = 0 ) {
	$forum_id = sbv_forum_get_id( $forum_id );

	$meta = get_post_meta( $forum_id, 'sbn_envato_items', true );

	if ( $meta == '' ) {
		$meta = array(
			'items'   => array(),
			'method'  => 'items',
			'protect' => 'global',
		);
	} else {
		if ( ! isset( $meta['method'] ) ) {
			$meta['method'] = 'items';
		}

		if ( ! isset( $meta['protect'] ) ) {
			$meta['protect'] = 'global';
		}
	}

	return $meta;
}

function sbv_forum_list_required_items( $forum_id = 0 ) {
	$raw = sbv_forum_get_envato_items( $forum_id );

	if ( $raw['method'] == 'account' ) {
		return 'account';
	} else {
		$items = array();
		foreach ( $raw['items'] as $item ) {
			if ( $item['status'] == 'found.ok' ) {
				$support = $item['support'] ?? 'auto';

				$_i = sbv_api()->item( $item['item'] );

				if ( ! is_wp_error( $_i ) ) {
					$_i->sbv_support = $support;
					$items[]         = $_i;
				}
			}
		}

		return $items;
	}
}

function sbv_user_list_envato_purchases( $user_id = 0 ) {
	if ( $user_id == 0 ) {
		$user_id = get_current_user_id();
	}

	if ( $user_id > 0 ) {
		$meta = get_user_meta( $user_id, 'sbv_envato_purchases', true );

		if ( $meta === false || $meta === '' ) {
			return array();
		} else {
			return $meta;
		}
	} else {
		return array();
	}
}

function sbv_add_purchase_code_to_user( $purchase_code, $user_id, $item_id = 0, $api_username = '', $api_code = '' ) {
	return sbv_validator()->add_purchase_code_to_user( $purchase_code, $user_id, $item_id, $api_username, $api_code );
}
