<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function sbv_delete_user_transient( $user_id, $transient ) {
	$transient_option  = '_transient_' . $transient;
	$transient_timeout = '_transient_timeout_' . $transient;

	delete_user_meta( $user_id, $transient_option );
	delete_user_meta( $user_id, $transient_timeout );
}

function sbv_get_user_transient( $user_id, $transient ) {
	$transient_option  = '_transient_' . $transient;
	$transient_timeout = '_transient_timeout_' . $transient;

	if ( get_user_meta( $user_id, $transient_timeout, true ) < time() ) {
		delete_user_meta( $user_id, $transient_option );
		delete_user_meta( $user_id, $transient_timeout );

		return false;
	}

	return get_user_meta( $user_id, $transient_option, true );
}

function sbv_set_user_transient( $user_id, $transient, $value, $expiration = 86400 ) {
	$transient_option  = '_transient_' . $transient;
	$transient_timeout = '_transient_timeout_' . $transient;

	if ( get_user_meta( $user_id, $transient_option, true ) != '' ) {
		delete_user_meta( $user_id, $transient_option );
		delete_user_meta( $user_id, $transient_timeout );
	}

	add_user_meta( $user_id, $transient_timeout, time() + $expiration, true );
	add_user_meta( $user_id, $transient_option, $value, true );
}

function sbv_unlink_purchase_code( $user_id, $item_id, $purchase_code ) {
	$meta = sbv_user_list_envato_purchases( $user_id );

	if ( isset( $meta[ $item_id ][ $purchase_code ] ) ) {
		unset( $meta[ $item_id ][ $purchase_code ] );

		if ( empty( $meta[ $item_id ] ) ) {
			unset( $meta[ $item_id ] );
		}
	}

	if ( empty( $meta ) ) {
		delete_user_meta( $user_id, 'sbv_envato_purchases' );
	} else {
		update_user_meta( $user_id, 'sbv_envato_purchases', $meta );
	}

	delete_user_meta( $user_id, 'sbv_envato_' . $item_id, $purchase_code );
}

function sbv_store_purchase_code( $user_id, $purchase_code, $verification ) {
	$meta = sbv_user_list_envato_purchases( $user_id );

	if ( ! isset( $meta[ $verification->item_id ] ) ) {
		$meta[ $verification->item_id ] = array();
	}

	$_item = array(
		'data'          => (array) $verification,
		'support'       => array(
			'active'    => true,
			'until'     => null,
			'september' => false,
		),
		'first_checked' => time(),
		'last_checked'  => time(),
	);

	$purchase_date  = strtotime( $verification->created_at );
	$september_date = strtotime( '1 September 2015' );

	if ( $purchase_date < $september_date ) {
		$_item['support']['september'] = true;
	}

	if ( empty( $verification->supported_until ) ) {
		$_item['support']['active'] = false;
	} else {
		if ( ! empty( $verification->supported_until ) ) {
			$until = strtotime( $verification->supported_until ) + DAY_IN_SECONDS;

			if ( time() < $until ) {
				$_item['support']['until'] = $until;
			} else {
				$_item['support']['active'] = false;
			}
		}
	}

	$meta[ $verification->item_id ][ $purchase_code ] = $_item;

	update_user_meta( $user_id, 'sbv_envato_purchases', $meta );
	add_user_meta( $user_id, 'sbv_envato_' . $verification->item_id, $purchase_code );

	do_action( 'sbv_purchase_code_added', $user_id, $purchase_code, $_item );
}

function sbv_is_current_user_with_role( $roles = 'administrator' ) {
	global $current_user;

	if ( is_user_logged_in() && is_array( $current_user->roles ) ) {
		$roles = (array) $roles;

		foreach ( $roles as $role ) {
			if ( in_array( $role, $current_user->roles ) ) {
				return true;
			}
		}
	}

	return false;
}
