<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'D4P_EOL' ) ) {
	define( 'D4P_EOL', "\r\n" );
}

if ( ! function_exists( 'd4p_strleft' ) ) {
	function d4p_strleft( $s1, $s2 ) {
		return substr( $s1, 0, strpos( $s1, $s2 ) );
	}
}

if ( ! function_exists( 'd4p_current_url' ) ) {
	function d4p_current_url( $use_wp = true ) {
		if ( $use_wp ) {
			$pathinfo = $_SERVER['PATH_INFO'] ?? '';
			list( $pathinfo ) = explode( '?', $pathinfo );
			$pathinfo = str_replace( '%', '%25', $pathinfo );

			$request         = explode( '?', $_SERVER['REQUEST_URI'] );
			$req_uri         = $request[0];
			$req_query       = $request[1] ?? false;
			$home_path       = trim( wp_parse_url( home_url(), PHP_URL_PATH ), '/' );
			$home_path_regex = sprintf( '|^%s|i', preg_quote( $home_path, '|' ) );

			$req_uri = str_replace( $pathinfo, '', $req_uri );
			$req_uri = ltrim( $req_uri, '/' );
			$req_uri = preg_replace( $home_path_regex, '', $req_uri );
			$req_uri = ltrim( $req_uri, '/' );

			$url_request = $req_uri;

			if ( $req_query !== false ) {
				$url_request .= '?' . $req_query;
			}

			return home_url( $url_request );
		} else {
			$s        = empty( $_SERVER['HTTPS'] ) ? '' : ( $_SERVER['HTTPS'] == 'on' ? 's' : '' );
			$protocol = d4p_strleft( strtolower( $_SERVER['SERVER_PROTOCOL'] ), '/' ) . $s;
			$port     = $_SERVER['SERVER_PORT'] == '80' || $_SERVER['SERVER_PORT'] == '443' ? '' : ':' . $_SERVER['SERVER_PORT'];

			return $protocol . '://' . $_SERVER['SERVER_NAME'] . $port . $_SERVER['REQUEST_URI'];
		}
	}
}

if ( ! function_exists( 'd4p_error_log' ) ) {
	function d4p_error_log( $log ) {
		if ( true === WP_DEBUG ) {
			if ( is_array( $log ) || is_object( $log ) ) {
				error_log( print_r( $log, true ) );
			} else {
				error_log( $log );
			}
		}
	}
}

if ( ! function_exists( 'd4p_print_r' ) ) {
	function d4p_print_r( $obj, $pre = true, $before = '', $after = '' ) {
		echo $before . D4P_EOL;

		if ( $pre ) {
			echo '<pre style="padding: 5px; font-size: 12px; background: #fff; border: 1px solid #000; color: #000;">';
		}

		print_r( $obj );

		if ( $pre ) {
			echo '</pre>';
		}

		echo $after . D4P_EOL;
	}
}
