<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

final class sbv_defaults {
	public $settings = array(
		'__version__'                                              => '4.2',
		'__date__'                                                 => '2024.06.30.',
		'__build__'                                                => '5750',
		'__status__'                                               => 'stable',
		'impact_affiliate'                                         => 4415,
		'impact_ad'                                                => 523004,
		'impact_id'                                                => 0,
		'global_marketplace'                                       => 'codecanyon',
		'global_user_name'                                         => '',
		'global_api_token'                                         => '',
		'global_support'                                           => false,
		'global_support_retired'                                   => false,
		'global_support_september'                                 => false,
		'global_support_exceptions'                                => array(),
		'global_support_period'                                    => 5,
		'ping_envato_api'                                          => false,
		'integrate_bbpress_disable_rss_feeds'                      => true,
		'integrate_bbpress_profile_active'                         => true,
		'integrate_bbpress_profile_visible_to_administrators'      => true,
		'integrate_bbpress_profile_visible_to_moderators'          => false,
		'integrate_bbpress_profile_bulk_active'                    => true,
		'integrate_bbpress_profile_bulk_visible_to_administrators' => false,
		'integrate_bbpress_profile_bulk_visible_to_moderators'     => false,
		'allow_multiple_users'                                     => false,
		'admin_show_forum_products_column'                         => true,
		'admin_show_forum_bulk_edit'                               => true,
		'handle_envato_support_urls'                               => true,
		'revalidate_purchase_code'                                 => true,
		'revalidate_period_days'                                   => 7,
		'access_unrestriced_user_roles'                            => array(
			'administrator',
			'bbp_keymaster',
			'bbp_moderator',
		),
		'access_control_reply'                                     => true,
		'access_control_topic'                                     => true,
		'access_control_forum'                                     => true,
		'access_control_search'                                    => true,
		'access_control_new_reply'                                 => true,
		'access_control_new_topic'                                 => true,
		'access_control_new_topic_noforum'                         => true,
		'verify_unique_purchase_code'                              => true,
	);

	function __construct() {
	}

	public function upgrade( $old ) {
		foreach ( $this->settings as $key => $value ) {
			if ( ! isset( $old[ $key ] ) ) {
				$old[ $key ] = $value;
			}
		}

		$unset = array();
		foreach ( $old as $key => $value ) {
			if ( ! isset( $this->settings[ $key ] ) ) {
				$unset[] = $key;
			}
		}

		if ( ! empty( $unset ) ) {
			foreach ( $unset as $key ) {
				unset( $old[ $key ] );
			}
		}

		foreach ( $this->settings as $key => $value ) {
			if ( substr( $key, 0, 2 ) == '__' ) {
				$old[ $key ] = $value;
			}
		}

		return $old;
	}
}
