<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class sbv_ajax_loader {
	function __construct() {
		add_action( 'wp_ajax_sbv_verify_purchase', array( $this, 'verify_purchase' ) );
		add_action( 'wp_ajax_nopriv_sbv_verify_purchase', array( $this, 'verify_purchase' ) );

		add_action( 'wp_ajax_sbv_verify_admin', array( $this, 'verify_admin' ) );
	}

	public function get( $name ) {
		return smart_sbv_core()->get( $name );
	}

	public function verify_admin() {
		if ( ! sbv_is_current_user_with_role() ) {
			die;
		}

		$nonce         = $_REQUEST['nonce'];
		$purchase_code = $_REQUEST['code'];
		$user_id       = intval( $_REQUEST['user'] );
		$user_name     = $_REQUEST['username'];
		$api_key       = $_REQUEST['apikey'];

		$test     = wp_verify_nonce( $nonce, 'smart-bbpress-nverify' );
		$result   = array( '<h3>' . esc_html__( 'Verification Status', 'smart-bbpress-nverify' ) . '</h3>' );
		$result[] = '<table class="form-table" style="width: 700px;"><tbody><tr valign="top">';

		if ( ! $test ) {
			$result[] = '<th scope="row">' . esc_html__( 'Error', 'smart-bbpress-nverify' ) . '</th>';
			$result[] = '<td>' . esc_html__( 'Invalid request. Code verification not executed.', 'smart-bbpress-nverify' ) . '</td>';
		} else {
			sbv_api()->access_custom( $user_name, $api_key );

			$verification = sbv_api()->verify_purchase( $purchase_code );

			$result[] = '<th scope="row">' . esc_html__( 'Status', 'smart-bbpress-nverify' ) . '</th>';
			$result[] = '<td>';

			if ( is_wp_error( $verification ) ) {
				$result[] = $verification->get_error_message();
			} else if ( is_object( $verification ) && ! isset( $verification->buyer ) ) {
				$result[] = esc_html__( 'Purchase Code is not associated with specified account.', 'smart-bbpress-nverify' );
			} else {
				foreach ( $verification as $code => $value ) {
					$result[] = $code . ': ' . $value . '<br/>';
				}

				if ( $user_id > 0 ) {
					$result[] = '<br/>';
					$result[] = '------------------------------------<br/><br/>';
					$result[] = esc_html__( 'Assign code to user', 'smart-bbpress-nverify' ) . '<br/>';

					if ( get_user_by( 'id', $user_id ) ) {
						$assign = sbv_add_purchase_code_to_user( $purchase_code, $user_id, 0, $user_name, $api_key );

						if ( $assign === true ) {
							$result[] = esc_html__( 'Purchase code assigned to specified user ID.', 'smart-bbpress-nverify' );
						} else {
							$result[] = $assign->get_error_message();
						}
					} else {
						$result[] = esc_html__( 'Invalid User ID', 'smart-bbpress-nverify' );
					}
				}
			}

			$result[] = '</td>';
		}

		$result[] = '</tr></tbody></table>';

		die( join( '', $result ) );
	}

	public function verify_purchase() {
		$nonce         = $_REQUEST['ctrl'];
		$purchase_code = $_REQUEST['code'];
		$forum_id      = intval( $_REQUEST['forum'] );
		$user_id       = get_current_user_id();

		$test   = wp_verify_nonce( $nonce, 'smart-bbpress-nverify-' . $user_id );
		$result = array( 'status' => 'ok' );

		if ( ! $test ) {
			$result['status']  = 'error';
			$result['message'] = esc_html__( 'Invalid request. Code verification not executed.', 'smart-bbpress-nverify' );
			$result['code']    = 'invalid_request';
		} else {
			$unique = sbv_validator()->is_purchase_code_unique( $purchase_code );

			if ( $unique ) {
				$items      = sbv_forum_get_envato_items( $forum_id );
				$found      = false;
				$error      = false;
				$error_code = false;

				if ( $items['method'] == 'account' ) {
					$result = sbv_validator()->validate_account( $purchase_code );
					extract( $result );
				} else {
					foreach ( $items['items'] as $item ) {
						if ( $item['status'] == 'found.ok' ) {
							$_username = $this->get( 'global_user_name' );
							$_apikey   = $this->get( 'global_api_token' );

							if ( $this->get( 'allow_multiple_users' ) && isset( $item['username'] ) && isset( $item['api_key'] ) && isset( $item['author'] ) && $item['author'] == 'custom' ) {
								$_username = $item['username'];
								$_apikey   = $item['api_key'];
							}

							$result = sbv_validator()->validate_item( $purchase_code, $item['item'], $_username, $_apikey );
							extract( $result );

							if ( $found !== false ) {
								break;
							}
						}
					}
				}

				if ( $found === false ) {
					$result['status']  = 'error';
					$result['message'] = $error;
					$result['code']    = $error_code;

					do_action( 'sbv_purchase_code_validation_failed', $user_id, $purchase_code, $result );
				} else {
					$result['status']  = 'ok';
					$result['message'] = esc_html__( 'Purchase code is valid, and it is saved with your account for later use. Please wait...', 'smart-bbpress-nverify' );

					sbv_store_purchase_code( $user_id, $purchase_code, $found );
				}
			} else {
				$result['status']  = 'error';
				$result['message'] = esc_html__( 'Purchase code is already registered by another user.', 'smart-bbpress-nverify' );
				$result['code']    = 'already_registered';

				do_action( 'sbv_purchase_code_already_registered', $user_id, $purchase_code, $result );
			}
		}

		die( json_encode( $result ) );
	}
}

$sbv_core_ajax = new sbv_ajax_loader();
