<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class sbv_admin {
	public $page_ids;
	public $admin_page_url = 'options-general.php';
	public $bulk_edit_added = false;
	public $validated = null;

	function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );

		add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		add_action( 'admin_menu', array( $this, 'admin_meta' ) );
		add_action( 'admin_init', array( $this, 'save_settings' ) );
		add_action( 'admin_init', array( $this, 'init_columns' ) );
		add_action( 'save_post', array( $this, 'save_edit_forum' ) );
		add_action( 'save_post', array( $this, 'bulk_edit_post' ) );
		add_filter( 'set-screen-option', array( $this, 'screen_options_grid_rows_save' ), 10, 3 );

		add_filter( 'plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 2 );
		add_filter( 'plugin_action_links_smart-bbpress-nverify/smart-bbpress-nverify.php', array(
			$this,
			'plugin_action_links',
		) );
	}

	public function screen_options_grid_rows_save( $status, $option, $value ) {
		if ( $option == 'sbv_rows_per_page_customers' ) {
			return $value;
		}

		return $status;
	}

	public function screen_options_grid_rows_customers() {
		if ( isset( $_GET['tab'] ) && $_GET['tab'] == 'customers' ) {
			$args = array(
				'label'   => esc_html__( 'Rows', 'smart-bbpress-nverify' ),
				'default' => 25,
				'option'  => 'sbv_rows_per_page_customers',
			);

			add_screen_option( 'per_page', $args );
		}
	}

	public function init_columns() {
		global $typenow, $pagenow;

		if ( smart_sbv_core()->get( 'admin_show_forum_products_column' ) ) {
			add_action( 'manage_forum_posts_columns', array( $this, 'admin_post_columns' ), 1000 );
			add_action( 'manage_forum_posts_custom_column', array( $this, 'admin_columns_data' ), 1000, 2 );
		}

		if ( smart_sbv_core()->get( 'admin_show_forum_bulk_edit' ) && $pagenow == 'edit.php' && $typenow == 'forum' ) {
			add_action( 'bulk_edit_custom_box', array( $this, 'bulk_edit_custom_box' ), 10, 2 );
		}
	}

	public function admin_post_columns( $columns ) {
		$columns['sbv_items'] = esc_html__( 'Envato Items', 'smart-bbpress-nverify' );

		return $columns;
	}

	public function admin_columns_data( $column, $id ) {
		if ( $column == 'sbv_items' ) {
			$items = sbv_forum_get_envato_items( $id );

			if ( $items['method'] == 'account' ) {
				esc_html_e( 'Any item for main Account', 'smart-bbpress-nverify' );
			} else {
				if ( empty( $items['items'] ) ) {
					echo '-';
				} else {
					foreach ( $items['items'] as $item ) {
						if ( $item['item'] != '' ) {
							$envato = sbv_api()->item( $item['item'] );
							echo $item['item'];

							if ( ! is_wp_error( $envato ) && isset( $envato->item ) ) {
								echo ': <a href="' . $envato->url . '" target="_blank">' . $envato->item . '</a>';
							}

							echo '<br/>';
						}
					}
				}
			}
		}
	}

	public function plugin_row_meta( $links, $plugin_file ) {
		if ( $plugin_file == 'smart-bbpress-nverify/smart-bbpress-nverify.php' ) {
			$links[] = 'SMART Plugins: <a href="https://www.smartplugins.info/" target="_blank">Website</a>';
			$links[] = '<a href="https://1.envato.market/xzxL5" target="_blank">On CodeCanyon</a>';

			$links = apply_filters( 'scs_admin_plugin_row_meta', $links );
		}

		return $links;
	}

	public function plugin_action_links( $links ) {
		$links[] = '<a href="' . $this->admin_page_url . '?page=smart-bbpress-nverify">' . esc_html__( 'Settings', 'smart-bbpress-nverify' ) . '</a>';

		return apply_filters( 'sbv_admin_plugin_action_links', $links );
	}

	public function admin_enqueue_scripts( $hook ) {
		if ( $hook == 'post.php' || $hook == 'edit.php' || $hook == 'post-new.php' ) {
			wp_enqueue_script( 'jquery' );

			wp_enqueue_script( 'sbv-admin-meta', ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? SBV_URL . 'js/meta.js' : SBV_URL . 'js/meta.min.js' ), array( 'jquery' ), null, true );
			wp_enqueue_style( 'sbv-admin-meta', ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? SBV_URL . 'css/meta.css' : SBV_URL . 'css/meta.min.css' ) );

			wp_localize_script( 'sbv-admin-meta', 'sbv_admin_meta_data', array(
				'text_are_you_sure' => esc_html__( 'Are you sure?', 'smart-bbpress-nverify' ),
			) );
		}

		if ( $hook == 'settings_page_smart-bbpress-nverify' || $hook == 'smart-plugins_page_smart-bbpress-nverify' || $hook == 'index_page_smart-bbpress-nverify' ) {
			wp_enqueue_script( 'jquery' );
			wp_enqueue_script( 'wpdialogs' );

			wp_enqueue_style( 'wp-jquery-ui-dialog' );

			wp_enqueue_script( 'sbv-mask', SBV_URL . 'libs/jquery.maskedinput.min.js', array( 'jquery' ), null, true );
			wp_enqueue_script( 'sbv-hide-show', SBV_URL . 'libs/jquery.hideshowpassword.min.js', array( 'jquery' ), null, true );
			wp_enqueue_script( 'sbv-admin', ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? SBV_URL . 'js/admin.js' : SBV_URL . 'js/admin.min.js' ), array(
				'jquery',
				'wpdialogs',
				'sbv-mask',
				'sbv-hide-show',
			), null, true );

			wp_enqueue_style( 'sbv-admin', ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? SBV_URL . 'css/admin.css' : SBV_URL . 'css/admin.min.css' ) );

			do_action( 'sbv_admin_enqueue_scripts' );
		}
	}

	public function admin_menu() {
		if ( defined( 'SMART_PLUGINS_CENTRAL' ) ) {
			$this->page_ids[] = add_submenu_page( 'smart-plugins-central', esc_html__( 'Smart bbPress nVerify', 'smart-bbpress-nverify' ), esc_html__( 'bbPress nVerify', 'smart-bbpress-nverify' ), 'activate_plugins', 'smart-bbpress-nverify', array(
				$this,
				'settings',
			) );
		} else {
			$this->page_ids[] = add_options_page( esc_html__( 'Smart bbPress nVerify', 'smart-bbpress-nverify' ), esc_html__( 'Smart bbPress nVerify', 'smart-bbpress-nverify' ), 'activate_plugins', 'smart-bbpress-nverify', array(
				$this,
				'settings',
			) );
		}

		foreach ( $this->page_ids as $id ) {
			add_action( 'load-' . $id, array( $this, 'load_admin_page' ) );
			add_action( 'load-' . $id, array( $this, 'screen_options_grid_rows_customers' ) );
		}
	}

	public function admin_meta() {
		add_meta_box( 'smart-nverify-meta-forum', esc_html__( 'Smart nVerify Protection', 'smart-bbpress-nverify' ), array(
			$this,
			'metabox_forum',
		), 'forum', 'side', 'high' );
	}

	public function bulk_edit_post( $post_id ) {
		if ( isset( $_REQUEST['bulk_edit'] ) ) {
			$_action = $_REQUEST['sbv_envato_items_action'] ?? 'noc';

			if ( $_action != 'noc' ) {
				$_list         = $_REQUEST['sbv_envato_items_list'] ?? '';
				$items         = array_map( 'trim', explode( ',', $_list ) );
				$current_items = sbv_forum_get_envato_items( $post_id );
				$meta          = array(
					'items'   => array(),
					'method'  => $current_items['method'],
					'protect' => $current_items['protect'],
				);

				if ( $_action == 'add' ) {
					$meta['items'] = $current_items['items'];
				}

				switch ( $_action ) {
					case 'add':
					case 'rep':
						if ( is_null( $this->validated ) ) {
							$this->validated = array();

							foreach ( $items as $id ) {
								$envato = sbv_api()->item( $id );

								if ( ! is_wp_error( $envato ) && isset( $envato->item ) ) {
									$item = array(
										'item'     => $id,
										'author'   => 'global',
										'status'   => 'found',
										'username' => '',
										'api_key'  => '',
										'support'  => 'auto',
									);

									if ( strtolower( smart_sbv_core()->get( 'global_user_name' ) ) == strtolower( $envato->user ) ) {
										$item['status']    .= '.ok';
										$this->validated[] = $item;
									}
								}
							}
						}

						foreach ( $this->validated as $item ) {
							$add = true;
							foreach ( $meta['items'] as $curr ) {
								if ( $curr['item'] == $item['item'] ) {
									$add = false;
								}
							}

							if ( $add ) {
								$meta['items'][] = $item;
							}
						}
						break;
					case 'del':
						$meta['items'] = array();
						break;
					case 'rem':
						foreach ( $current_items['items'] as $item ) {
							if ( ! in_array( $item['item'], $items ) ) {
								$meta['items'][] = $item;
							}
						}
						break;
				}

				if ( empty( $meta['items'] ) && $meta['method'] == 'items' ) {
					delete_post_meta( $post_id, 'sbn_envato_items' );
				} else {
					update_post_meta( $post_id, 'sbn_envato_items', $meta );
				}
			}
		}
	}

	public function save_edit_forum( $post_id ) {
		if ( isset( $_POST['post_ID'] ) && $_POST['post_ID'] > 0 ) {
			$post_id = $_POST['post_ID'];
		}

		if ( isset( $_POST['sbv-meta-items'] ) ) {
			$listed = array();
			$meta   = array(
				'items'   => array(),
				'method'  => $_REQUEST['sbvmethod'] ?? 'items',
				'protect' => 'global',
			);

			$results = $_POST['sbvitem'];

			foreach ( $results as $id => $item ) {
				$item = array_map( 'trim', $item );

				if ( $id > 0 && $item['item'] != '' && ! in_array( $item['item'], $listed ) ) {
					$envato = sbv_api()->item( $item['item'] );

					if ( is_wp_error( $envato ) || ! isset( $envato->item ) ) {
						$item['status'] = 'error';
					} else {
						$item['status'] = 'found';

						if ( $item['author'] == 'custom' ) {
							if ( $item['username'] != '' && $item['api_key'] != '' ) {
								sbv_api()->access_custom( $item['username'], $item['api_key'] );
								$author = sbv_api()->vitals();

								if ( is_wp_error( $author ) ) {
									$item['author']   = 'global';
									$item['username'] = '';
									$item['api_key']  = '';
									$item['status']   .= '.wrong';
								} else {
									if ( strtolower( $item['username'] ) == strtolower( $envato->user ) ) {
										$item['status'] .= '.ok';
									} else {
										$item['status'] .= '.wrong';
									}
								}
							} else {
								$item['author']   = 'global';
								$item['username'] = '';
								$item['api_key']  = '';
								$item['status']   .= '.wrong';
							}
						} else {
							if ( strtolower( smart_sbv_core()->get( 'global_user_name' ) ) == strtolower( $envato->user ) ) {
								$item['status'] .= '.ok';
							} else {
								$item['status'] .= '.wrong';
							}
						}
					}

					$meta['items'][] = $item;
					$listed[]        = $item['item'];
				}
			}

			if ( empty( $meta['items'] ) && $meta['method'] == 'items' ) {
				delete_post_meta( $post_id, 'sbn_envato_items' );
			} else {
				update_post_meta( $post_id, 'sbn_envato_items', $meta );
			}
		}
	}

	public function metabox_forum() {
		$account = sbv_api()->is_account_set();

		if ( is_wp_error( $account ) ) {
			echo '<a href="' . $this->admin_page_url . '?page=smart-bbpress-nverify">' . esc_html__( 'Set up Envato Account', 'smart-bbpress-nverify' ) . '</a>';
		} else {
			global $post_ID;

			include( SBV_PATH . 'forms/meta.php' );
		}
	}

	public function bulk_edit_custom_box( $column_name, $post_type ) {
		if ( ! $this->bulk_edit_added ) {
			include( SBV_PATH . 'forms/bulk.php' );

			$this->bulk_edit_added = true;
		}
	}

	public function load_admin_page() {
		$screen = get_current_screen();

		$screen->set_help_sidebar( '
            <p><strong>SMART Plugins:</strong></p>
            <p><a target="_blank" href="https://www.smartplugins.info/">' . esc_html__( 'Website', 'smart-bbpress-nverify' ) . '</a></p>
            <p><a target="_blank" href="https://1.envato.market/xzxL5">' . esc_html__( 'On CodeCanyon', 'smart-bbpress-nverify' ) . '</a></p>
            <p><a target="_blank" href="https://twitter.com/millanrs">' . esc_html__( 'On Twitter', 'smart-bbpress-nverify' ) . '</a></p>
            <p><a target="_blank" href="https://facebook.com/smartplugins">' . esc_html__( 'On Facebook', 'smart-bbpress-nverify' ) . '</a></p>' );

		$screen->add_help_tab( array(
			'id'      => 'scs-screenhelp-info',
			'title'   => esc_html__( 'Information', 'smart-bbpress-nverify' ),
			'content' => '<p>' . esc_html__( 'Integrate with bbPress forums to implement verification of the Envato purchase codes. Assign one or more Envato items to forums for purchase only access.', 'smart-bbpress-nverify' ) . '</p>
                <h5>' . esc_html__( 'Useful Links', 'smart-bbpress-nverify' ) . '</h5>
                <p><a target="_blank" href="https://www.smartplugins.info/plugin/wordpress/smart-bbpress-nverify/">' . esc_html__( 'Plugin Homepage', 'smart-bbpress-nverify' ) . '</a></p>
                <p><a target="_blank" href="https://d4p.me/ccscs">' . esc_html__( 'Plugin On CodeCanyon', 'smart-bbpress-nverify' ) . '</a></p>',
		) );

		$screen->add_help_tab( array(
			'id'      => 'scs-screenhelp-support',
			'title'   => esc_html__( 'Support', 'smart-bbpress-nverify' ),
			'content' => '<h5>' . esc_html__( 'Support Resources', 'smart-bbpress-nverify' ) . '</h5>
                <p><a target="_blank" href="https://support.smartplugins.info/forums/forum/wordpress/smart-bbpress-nverify/">' . esc_html__( 'Official Support Forum', 'smart-bbpress-nverify' ) . '</a></p>',
		) );
	}

	public function save_settings() {
		if ( defined( 'SMART_PLUGINS_CENTRAL' ) ) {
			$this->admin_page_url = 'admin.php';
		}

		if ( ! sbv_is_current_user_with_role() ) {
			return;
		}

		if ( isset( $_POST['option_page'] ) && $_POST['option_page'] == 'smart-bbpress-nverify-tools' ) {
			check_admin_referer( 'smart-bbpress-nverify-tools-options' );

			$url = $this->admin_page_url . '?page=smart-bbpress-nverify&tab=tools';

			if ( isset( $_POST['sbv']['cache_clear'] ) ) {
				sbv_api()->clear_cache();

				$url .= '&cache-cleared=true';
			}

			if ( isset( $_POST['sbv']['log_clear'] ) ) {
				if ( file_exists( sbv_api()->object->log ) ) {
					unlink( sbv_api()->object->log );
				}

				$url .= '&log-cleared=true';
			}

			wp_redirect( $url );
			exit;
		}

		if ( isset( $_GET['page'] ) && $_GET['page'] == 'smart-bbpress-nverify' && isset( $_GET['tab'] ) && $_GET['tab'] == 'customers' ) {
			if ( isset( $_GET['single-action'] ) ) {
				$action = isset( $_GET['user'] ) ? $_GET['single-action'] : '';
				$user   = $_GET['user'] ?? 0;
				$item   = $_GET['item'] ?? '';
				$code   = $_GET['code'] ?? '';
				$nonce  = $_GET['_wpnonce'] ?? '';

				if ( $action != '' ) {
					if ( $action == 'unlink' && wp_verify_nonce( $nonce, 'sbv-remove-' . $user . '-' . $item . '-' . $code ) !== false ) {
						sbv_unlink_purchase_code( $user, $item, $code );

						wp_redirect( $this->admin_page_url . '?page=smart-bbpress-nverify&tab=customers&unlink-done=true' );
						exit;
					}

					if ( $action == 'revalidate' && wp_verify_nonce( $nonce, 'sbv-revalidate-' . $user ) !== false ) {
						sbv_validator()->revalidate( $user, 30 );

						wp_redirect( $this->admin_page_url . '?page=smart-bbpress-nverify&tab=customers&revalidation-done=true' );
						exit;
					}
				}
			}
		}

		if ( isset( $_POST['option_page'] ) && $_POST['option_page'] == 'smart-bbpress-nverify-settings' ) {
			check_admin_referer( 'smart-bbpress-nverify-settings-options' );

			$revalidate_days = intval( strip_tags( stripslashes( $_POST['sbv']['revalidate_period_days'] ) ) );
			$recheck_minutes = intval( strip_tags( stripslashes( $_POST['sbv']['global_support_period'] ) ) );

			if ( $revalidate_days < 1 ) {
				$revalidate_days = 7;
			}

			if ( $recheck_minutes < 1 ) {
				$recheck_minutes = 1;
			}

			$items = explode( ',', $_POST['sbv']['global_support_exceptions'] );

			if ( ! empty( $items ) ) {
				$items = array_map( 'trim', $items );
				$items = array_map( 'intval', $items );
			}

			smart_sbv_core()->set( 'allow_multiple_users', isset( $_POST['sbv']['allow_multiple_users'] ) );
			smart_sbv_core()->set( 'access_control_reply', isset( $_POST['sbv']['access_control_reply'] ) );
			smart_sbv_core()->set( 'access_control_topic', isset( $_POST['sbv']['access_control_topic'] ) );
			smart_sbv_core()->set( 'access_control_forum', isset( $_POST['sbv']['access_control_forum'] ) );
			smart_sbv_core()->set( 'access_control_search', isset( $_POST['sbv']['access_control_search'] ) );
			smart_sbv_core()->set( 'access_control_new_reply', isset( $_POST['sbv']['access_control_new_reply'] ) );
			smart_sbv_core()->set( 'access_control_new_topic', isset( $_POST['sbv']['access_control_new_topic'] ) );
			smart_sbv_core()->set( 'access_control_new_topic_noforum', isset( $_POST['sbv']['access_control_new_topic_noforum'] ) );
			smart_sbv_core()->set( 'verify_unique_purchase_code', isset( $_POST['sbv']['verify_unique_purchase_code'] ) );

			smart_sbv_core()->set( 'impact_affiliate', absint( $_POST['sbv']['impact_affiliate'] ) );
			smart_sbv_core()->set( 'impact_id', absint( $_POST['sbv']['impact_id'] ) );
			smart_sbv_core()->set( 'impact_ad', absint( $_POST['sbv']['impact_ad'] ) );

			smart_sbv_core()->set( 'revalidate_purchase_code', isset( $_POST['sbv']['revalidate_purchase_code'] ) );
			smart_sbv_core()->set( 'revalidate_period_days', $revalidate_days );

			smart_sbv_core()->set( 'access_unrestriced_user_roles', (array) $_POST['sbv']['access_unrestriced_user_roles'] );

			smart_sbv_core()->set( 'global_user_name', strip_tags( stripslashes( $_POST['sbv']['global_user_name'] ) ) );
			smart_sbv_core()->set( 'global_api_token', strip_tags( stripslashes( $_POST['sbv']['global_api_token'] ) ) );
			smart_sbv_core()->set( 'global_marketplace', strip_tags( stripslashes( $_POST['sbv']['global_marketplace'] ) ) );
			smart_sbv_core()->set( 'global_support', isset( $_POST['sbv']['global_support'] ) );
			smart_sbv_core()->set( 'global_support_september', isset( $_POST['sbv']['global_support_september'] ) );
			smart_sbv_core()->set( 'global_support_retired', isset( $_POST['sbv']['global_support_retired'] ) );
			smart_sbv_core()->set( 'global_support_exceptions', $items );
			smart_sbv_core()->set( 'global_support_period', $recheck_minutes );

			smart_sbv_core()->set( 'ping_envato_api', isset( $_POST['sbv']['ping_envato_api'] ) );
			smart_sbv_core()->set( 'admin_show_forum_products_column', isset( $_POST['sbv']['admin_show_forum_products_column'] ) );
			smart_sbv_core()->set( 'admin_show_forum_bulk_edit', isset( $_POST['sbv']['admin_show_forum_bulk_edit'] ) );
			smart_sbv_core()->set( 'handle_envato_support_urls', isset( $_POST['sbv']['handle_envato_support_urls'] ) );
			smart_sbv_core()->set( 'integrate_bbpress_profile_active', isset( $_POST['sbv']['integrate_bbpress_profile_active'] ) );
			smart_sbv_core()->set( 'integrate_bbpress_profile_visible_to_administrators', isset( $_POST['sbv']['integrate_bbpress_profile_visible_to_administrators'] ) );
			smart_sbv_core()->set( 'integrate_bbpress_profile_visible_to_moderators', isset( $_POST['sbv']['integrate_bbpress_profile_visible_to_moderators'] ) );
			smart_sbv_core()->set( 'integrate_bbpress_profile_bulk_active', isset( $_POST['sbv']['integrate_bbpress_profile_bulk_active'] ) );
			smart_sbv_core()->set( 'integrate_bbpress_profile_bulk_visible_to_administrators', isset( $_POST['sbv']['integrate_bbpress_profile_bulk_visible_to_administrators'] ) );
			smart_sbv_core()->set( 'integrate_bbpress_profile_bulk_visible_to_moderators', isset( $_POST['sbv']['integrate_bbpress_profile_bulk_visible_to_moderators'] ) );

			sbv_api()->clear_cache();

			smart_sbv_core()->save();
			wp_redirect( $this->admin_page_url . '?page=smart-bbpress-nverify&settings-updated=true&tab=settings' );
			exit;
		}
	}

	public function settings() {
		if ( isset( $_GET['tab'] ) && $_GET['tab'] == 'about' ) {
			$about = smart_sbv_core()->settings;
		} else {
			$settings = smart_sbv_core()->settings;
		}

		do_action( 'sbv_admin_display_panel_before' );

		include( SBV_PATH . 'forms/index.php' );

		do_action( 'sbv_admin_display_panel_after' );
	}
}

global $sbv_core_admin;
$sbv_core_admin = new sbv_admin();
