<div id="sbv-profile-purchase-codes" class="bbp-user-profile sbv-user-purchase-codes">
    <h2 class="entry-title"><?php esc_html_e( 'Registered Purchase Codes', 'smart-bbpress-nverify' ); ?></h2>
    <div class="bbp-user-section">

		<?php

		if ( isset( $_GET['sbvbulk'] ) ) {
			$added = intval( $_GET['sbvbulk'] );

			echo '<div class="bbp-template-notice info"><p>';
			echo sprintf( esc_html__( '%s %s added successfully.', 'smart-bbpress-nverify' ), $added, _n( 'purchase code', 'purchase codes', $added, 'smart-bbpress-nverify' ) );
			echo '</p></div>';
		}

		$user_id = bbp_get_user_id();
		$codes   = get_user_meta( $user_id, 'sbv_envato_purchases', true );
		$support = apply_filters( 'sbv_check_support_status', smart_sbv_core()->get( 'global_support' ) );

		if ( $codes == '' ) {
			echo '<p>' . esc_html__( 'You don\'t have any registered purchase codes.', 'smart-bbpress-nverify' ) . '</p>';
		} else {
			foreach ( $codes as $item => $list ) {
				$envato = sbv_api()->item( $item );

				$thumbnail = isset( $envato->url ) ? $envato->thumbnail : 'data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==';
				$url       = isset( $envato->url ) ? $envato->url : '#';

				$obj = reset( $list );

				?>

                <div class="sbv-user-envato-item">
					<?php if ( $url != '#' ) { ?>
                        <a target="_blank" href="<?php echo $url; ?>"><img width="80" height="80" src="<?php echo $thumbnail; ?>" alt="<?php echo $obj['data']['item_name']; ?>"/></a>
					<?php } ?>
                    <div class="sbv-user-item-content">
						<?php if ( $url == '#' ) { ?>
                            <h4><?php echo $obj['data']['item_name']; ?></h4>
                            <em><?php esc_html_e( 'This item is no longer available.', 'smart-bbpress-nverify' ); ?></em>
						<?php } else { ?>
                            <h4>
                                <a target="_blank" href="<?php echo $url; ?>"><?php echo $obj['data']['item_name']; ?></a>
                            </h4>
						<?php } ?>
                        <ul>
							<?php foreach ( $list as $pc => $obj ) { ?>
                                <li>
                                    <span><?php echo $pc; ?></span>
                                    <p>
										<?php echo '<strong>' . $obj['data']['licence'] . '</strong>'; ?><br/>
										<?php echo esc_html__( 'Purchased by', 'smart-bbpress-nverify' ) . ' <u>' . $obj['data']['buyer'] . '</u> '; ?>
										<?php echo esc_html__( 'on', 'smart-bbpress-nverify' ) . ' ' . date( get_option( 'date_format' ), strtotime( $obj['data']['created_at'] ) ); ?>
                                        <br/>
										<?php echo esc_html__( 'Code registered on', 'smart-bbpress-nverify' ) . ' ' . date( get_option( 'date_format' ), $obj['first_checked'] ); ?>
                                        <br/>
										<?php

										if ( $support && isset( $obj['support'] ) ) {
											if ( $obj['support']['active'] && is_numeric( $obj['support']['until'] ) && $obj['support']['until'] > 0 ) {
												echo esc_html__( 'Supported until', 'smart-bbpress-nverify' ) . ' ' . date( get_option( 'date_format' ), $obj['support']['until'] );
											} else {
												echo esc_html__( 'Support period expired.', 'smart-bbpress-nverify' );
											}
										}

										?>
                                    </p>
                                </li>
							<?php } ?>
                        </ul>
                    </div>
                </div>

				<?php
			}
		}

		?>

    </div>
</div>
