<div id="sbv-profile-purchase-bulk" class="bbp-user-profile sbv-user-purchase-bulk">
    <h2 class="entry-title"><?php esc_html_e( 'Bulk Add Purchase Codes', 'smart-bbpress-nverify' ); ?></h2>
    <div class="bbp-user-section">

		<?php

		if ( sbv_bbpress()->bulk_store_errors !== false ) {
			echo '<div class="bbp-template-notice error"><p>';
			echo esc_html__( 'Your bulk request had some errors:', 'smart-bbpress-nverify' );
			echo '</p><ul>';

			foreach ( sbv_bbpress()->bulk_store_errors->errors as $code => $errors ) {
				foreach ( $errors as $msg ) {
					echo '<li>' . $msg . '</li>';
				}
			}

			echo '</ul></div>';
		}

		?>

        <p>
			<?php esc_html_e( 'Add one or more purchase codes. If the code is valid and not already in use, it will be added to your account.', 'smart-bbpress-nverify' ); ?>
			<?php esc_html_e( 'Codes must be for items for this Envato account', 'smart-bbpress-nverify' ); ?>: <?php sbv_render_account_link(); ?>.
        </p>

        <form action="" method="POST">
            <input name="sbv[bulk]" type="hidden" value="add"/>
            <input name="sbv[user]" type="hidden" value="<?php echo bbp_get_user_id(); ?>"/>
            <input name="sbv[verify]" type="hidden" value="<?php echo wp_create_nonce( 'smart-bbpress-nverify-' . get_current_user_id() ); ?>"/>

            <div class="sbv-bulk-code-block">
                <input name="sbv[codes][]" type="text"/>
                <input name="sbv[codes][]" type="text"/>
                <input name="sbv[codes][]" type="text"/>
            </div>

            <button class="button sbv-bulk-add-more" type="button">+</button>

            <div class="sbv-bulk-code-block-submit">
                <button class="button submit user-submit" type="submit"><?php esc_html_e( 'Add Purchase Codes', 'smart-bbpress-nverify' ); ?></button>
            </div>
        </form>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() {
        window.wp.smartplugins.verification.profile();
    });
</script>
