<?php

global $sbv_forum_id, $sbv_default_notice;

$_forum_id = $sbv_forum_id ?? 0;

$items = sbv_forum_list_required_items( $_forum_id );

$sbv_default_notice = $sbv_default_notice ?? __( 'You must have valid license to access this forum.', 'smart-bbpress-nverify' );

?>
<div id="bbpress-forums">
    <div id="sbv-protection-block">
		<?php sbv_show_notice( $sbv_default_notice, 'error' ); ?>

        <fieldset class="bbp-form">
            <legend><?php _e( 'Support period has expired', 'smart-bbpress-nverify' ); ?></legend>
			<?php sbv_show_notice( __( 'Support has expired, and you need to purchase Support extension before you can access this forum again.', 'smart-bbpress-nverify' ), 'info' ); ?>

			<?php

			if ( $items === 'account' ) {
				sbv_render_account();
			} else {
				foreach ( $items as $item ) {
					sbv_render_item( $item );
				}
			}

			?>
			<?php sbv_show_notice( __( 'Once you purchase support extension, wait few minutes, visit this page again and refresh.', 'smart-bbpress-nverify' ), 'info' ); ?>
        </fieldset>
    </div>
</div>
