<?php

global $sbv_forum_id, $sbv_validate_action, $sbv_default_notice;

$_forum_id    = $sbv_forum_id ?? 0;
$_onok_action = $sbv_validate_action ?? 'reload';

$items = sbv_forum_list_required_items( $_forum_id );

$items_list_title = $items === 'account'
	? __( 'License required for any item belonging to this account', 'smart-bbpress-nverify' )
	:
	( count( $items ) == 1
		? __( 'License required for the following item', 'smart-bbpress-nverify' )
		:
		__( 'License required for one of the following items', 'smart-bbpress-nverify' ) );

$sbv_default_notice = $sbv_default_notice ?? __( 'You must have valid license to access this forum.', 'smart-bbpress-nverify' );

?>
<div id="bbpress-forums">
    <div id="sbv-protection-block">
		<?php sbv_show_notice( $sbv_default_notice, 'error' ); ?>

        <fieldset class="bbp-form">
            <legend><?php echo $items_list_title; ?></legend>
			<?php sbv_show_notice( __( 'Before you can access this forum you need to purchase a license.', 'smart-bbpress-nverify' ), 'info' ); ?>

			<?php

			if ( $items === 'account' ) {
				sbv_render_account();
			} else {
				foreach ( $items as $item ) {
					sbv_render_item( $item );
				}
			}

			?>
        </fieldset>

        <fieldset class="bbp-form">
            <legend><?php esc_html_e( 'Enter your purchase code', 'smart-bbpress-nverify' ); ?></legend>
			<?php sbv_show_notice( __( 'Enter the purchase code, click Verify button and wait for the verification process to complete.', 'smart-bbpress-nverify' ), 'info' ); ?>

            <div class="sbv-purchase-code">
                <label><?php esc_html_e( 'Purchase Code', 'smart-bbpress-nverify' ); ?>:</label>
                <input id="sbv-verify-code" type="text"/>
            </div>
            <div class="sbv-purchase-submit">
                <div class="bbp-template-notice sbv-wait" style="display: none;">
                    <p><?php esc_html_e( 'Please wait, verification in progress...', 'smart-bbpress-nverify' ); ?></p>
                </div>
                <input id="sbv-verify-ctrl" type="hidden" value="<?php echo wp_create_nonce( 'smart-bbpress-nverify-' . get_current_user_id() ); ?>"/>
                <input id="sbv-verify-onok" type="hidden" value="<?php echo $_onok_action; ?>"/>
                <input id="sbv-verify-frid" type="hidden" value="<?php echo $_forum_id; ?>"/>
                <input id="sbv-verify-exec" type="button" value="<?php esc_attr_e( 'Verify', 'smart-bbpress-nverify' ); ?>"/>
            </div>
        </fieldset>

        <fieldset class="bbp-form">
            <legend><?php esc_html_e( 'Where can I find my purchase code?', 'smart-bbpress-nverify' ); ?></legend>
            <a class="sbv-show-where-step" href="#"><?php esc_html_e( 'Click here to show how to get purchase code.', 'smart-bbpress-nverify' ); ?></a>

            <div style="display: none">
                <div class="sbv-code-where-step">
                    <img width="400" height="200" src="<?php echo SBV_URL . 'gfx/purchase_code/step_1_download.png'; ?>" alt=""/>
                    <h5>1. <?php esc_html_e( 'Open your account Download page', 'smart-bbpress-nverify' ); ?></h5>
                    <em><?php esc_html_e( 'Log into your Envato account and hover over your account name. Drop down menu will open. Click on the <strong>Downloads</strong>.', 'smart-bbpress-nverify' ); ?></em>
                </div>
                <div class="sbv-code-where-step">
                    <img width="400" height="200" src="<?php echo SBV_URL . 'gfx/purchase_code/step_2_license.png'; ?>" alt=""/>
                    <h5>2. <?php esc_html_e( 'Open item Download menu to get License file', 'smart-bbpress-nverify' ); ?></h5>
                    <em><?php esc_html_e( 'You will get the list of all items you purchased. Find the one you need to get the purchase code for, and click on the Download button. Drop down menu will open. Click on <strong>License certificate &amp; purchase code</strong>. Save the license file.', 'smart-bbpress-nverify' ); ?></em>
                </div>
                <div class="sbv-code-where-step">
                    <img width="400" height="200" src="<?php echo SBV_URL . 'gfx/purchase_code/step_3_code.png'; ?>" alt=""/>
                    <h5>3. <?php esc_html_e( 'Open License and find Purchase Code', 'smart-bbpress-nverify' ); ?></h5>
                    <em><?php esc_html_e( 'Open the file you saved with any text editor. Find the line with <strong>Item Purchase Code</strong>. Select the code and copy it.', 'smart-bbpress-nverify' ); ?></em>
                </div>
            </div>
        </fieldset>
    </div>
</div>
