<?php

global $sbv_forum_id, $sbv_validate_action, $sbv_default_notice;

$_forum_id = $sbv_forum_id ?? 0;

$items = sbv_forum_list_required_items( $_forum_id );

$items_list_title = $items === 'account'
	? __( 'License required for any item belonging to this account', 'smart-bbpress-nverify' )
	:
	( count( $items ) == 1
		? __( 'License required for the following item', 'smart-bbpress-nverify' )
		:
		__( 'License required for one of the following items', 'smart-bbpress-nverify' ) );

$sbv_default_notice = $sbv_default_notice ?? __( 'You must be logged in and have valid license to access this forum.', 'smart-bbpress-nverify' );

?>
<div id="bbpress-forums">
    <div id="sbv-protection-block">
		<?php sbv_show_notice( $sbv_default_notice, 'error' ); ?>

        <fieldset class="bbp-form">
            <legend><?php echo esc_html( $items_list_title ); ?></legend>

			<?php

			if ( $items === 'account' ) {
				sbv_render_account();
			} else {
				foreach ( $items as $item ) {
					sbv_render_item( $item );
				}
			}

			?>
        </fieldset>

        <fieldset class="bbp-form">
            <legend><?php esc_html_e( 'Login and Registration', 'smart-bbpress-nverify' ); ?></legend>
			<?php wp_loginout( d4p_current_url() ); ?> &middot;
			<?php wp_register( '', '' ); ?>
        </fieldset>
    </div>
</div>
